<?php
echo "Testing simplified cumplimiento endpoint...\n";

$testCode = '
<?php
session_start();
$_SESSION["usuario_id"] = 1;
$_GET["fecha_desde"] = "' . date('Y-m-d', strtotime('-7 days')) . '";
$_GET["fecha_hasta"] = "' . date('Y-m-d') . '";
require "api/reportes/embarque_cumplimiento_simple.php";
';

$tempFile = tempnam(sys_get_temp_dir(), 'test_simplified_');
file_put_contents($tempFile, $testCode);

$result = shell_exec("cd " . escapeshellarg(__DIR__) . " && php " . escapeshellarg($tempFile) . " 2>&1");
unlink($tempFile);

echo "Result:\n";
echo $result;

$jsonStart = strrpos($result, '{');
if ($jsonStart !== false) {
    $jsonPart = substr($result, $jsonStart);
    $data = json_decode($jsonPart, true);
    
    if (json_last_error() === JSON_ERROR_NONE && isset($data['ok'])) {
        if ($data['ok']) {
            echo "\n✅ SIMPLIFIED ENDPOINT WORKS!\n";
            echo "   Found " . count($data['data']) . " embarques\n";
            echo "   Total states: " . count($data['filter_options']['estados']) . "\n";
        } else {
            echo "\n❌ Error: " . $data['error'] . "\n";
        }
    }
}