<?php
require_once 'config/db.php';

echo "=== PRUEBA PLAN FEFO EN MODO SIMULACIÓN ===\n\n";

// Simular la llamada AJAX al endpoint
$postData = [
    'so_id' => 28,
    'deposito_code' => 'DEP1', 
    'prep_posicion_id' => 3,
    'debug' => 1,
    'simulate' => 1  // MODO SIMULACIÓN
];

echo "Simulando llamada a so_preparar_auto.php con:\n";
echo json_encode($postData, JSON_PRETTY_PRINT) . "\n\n";

// Hacer la llamada usando cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://sol.test/api/operaciones/so_preparar_auto.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen(json_encode($postData))
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);

echo "Ejecutando llamada...\n";
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "Código HTTP: $httpCode\n";
if ($error) {
    echo "Error cURL: $error\n";
}

echo "\nRespuesta:\n";
echo $response . "\n";

// Decodificar respuesta JSON si es posible
if ($response) {
    $decoded = json_decode($response, true);
    if ($decoded) {
        echo "\nRespuesta decodificada:\n";
        echo "- OK: " . ($decoded['ok'] ? 'true' : 'false') . "\n";
        if (isset($decoded['error'])) {
            echo "- Error: " . $decoded['error'] . "\n";
        }
        if (isset($decoded['message'])) {
            echo "- Mensaje: " . $decoded['message'] . "\n";
        }
        if (isset($decoded['plan']) && is_array($decoded['plan'])) {
            echo "- Plan generado: " . count($decoded['plan']) . " elementos\n";
        }
    }
}
?>