<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    echo "Testing SO-20 with CLI approach...\n";
    
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get pedido info
    $stmt = $pdo->prepare('SELECT codigo, estado_id FROM so_pedido WHERE id = 20');
    $stmt->execute();
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$pedido) {
        echo "SO-20 not found\n";
        exit;
    }
    
    echo "Found pedido: {$pedido['codigo']}, estado: {$pedido['estado_id']}\n";
    
    // Check for existing preembarque
    $stmt = $pdo->prepare('SELECT id FROM so_preembarque WHERE codigo = ?');
    $stmt->execute(['PRE-' . $pedido['codigo']]);
    $existingPre = $stmt->fetchColumn();
    
    if ($existingPre) {
        echo "WARNING: Preembarque already exists (ID: $existingPre)\n";
    } else {
        echo "No existing preembarque - good to go\n";
    }
    
    // Test SP execution
    echo "Executing stored procedure...\n";
    $start = microtime(true);
    
    $stmt = $pdo->prepare('CALL sp_so_preparar_auto(?,?,?,?)');
    $stmt->execute([$pedido['codigo'], 'DEP1', null, 0]);
    
    $duration = round((microtime(true) - $start) * 1000, 2);
    echo "SP completed in {$duration}ms\n";
    
    // Collect results
    $sets = [];
    do {
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($rows !== false && $rows) {
            $sets[] = $rows;
        }
    } while ($stmt->nextRowset());
    
    echo "Result sets: " . count($sets) . "\n";
    
    // Check new preembarque
    $stmt = $pdo->prepare('SELECT id FROM so_preembarque WHERE codigo = ?');
    $stmt->execute(['PRE-' . $pedido['codigo']]);
    $newPre = $stmt->fetchColumn();
    
    if ($newPre) {
        echo "New preembarque created: ID $newPre\n";
        
        // Update pedido state
        $stmt = $pdo->prepare('SELECT id FROM so_pedido_estado WHERE code = ?');
        $stmt->execute(['REPOSICION']);
        $estadoId = $stmt->fetchColumn();
        
        if ($estadoId) {
            $stmt = $pdo->prepare('UPDATE so_pedido SET estado_id = ? WHERE id = 20');
            $stmt->execute([$estadoId]);
            echo "Pedido state updated to REPOSICION\n";
        }
    }
    
    echo "Test completed successfully!\n";
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
?>