<?php
require_once __DIR__ . '/../config/db.php';
$pdo = getPDO();
$plId = (int)($argv[1] ?? 10);
try {
    // Candidate columns we might want to read from pl_ingreso
    $candidates = [
        'movil_id','chofer_id','movil_desc','chofer_desc','fecha_ingreso','llegada_at',
        'descarga_inicio_at','descarga_fin_at','operarios_cant','doc_tipo','doc_numero','observacion'
    ];

    // Query INFORMATION_SCHEMA to see which of those columns actually exist
    $inList = implode(',', array_map(function($c){ return "'".addslashes($c)."'"; }, $candidates));
    $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'pl_ingreso' AND COLUMN_NAME IN ($inList)";
    $res = $pdo->query($sql)->fetchAll(PDO::FETCH_COLUMN) ?: [];

    if (count($res) > 0) {
        $select = implode(', ', array_map(function($c){ return "`$c`"; }, $res));
        $st = $pdo->prepare("SELECT $select FROM pl_ingreso WHERE packinglist_id = ? ORDER BY created_at DESC LIMIT 1");
    } else {
        // fallback to select * (may include columns we don't expect, but avoids failure)
        $st = $pdo->prepare("SELECT * FROM pl_ingreso WHERE packinglist_id = ? ORDER BY created_at DESC LIMIT 1");
    }

    $st->execute([$plId]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    echo json_encode(['ok' => true, 'pl_id' => $plId, 'row' => $row], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
} catch (Throwable $e) {
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]) . "\n";
}
