<?php
// scripts/tmp_fetch_resumen.php
declare(strict_types=1);
if ($argc < 2) { echo "Usage: php scripts/tmp_fetch_resumen.php PL_ID\n"; exit(1); }
$pl = (int)$argv[1];
$url = "http://sol.test/api/operaciones/recepcion.php?meta=pl_resumen&pl_id={$pl}";
$options = [
  "http" => ["timeout" => 10]
];
$ctx = stream_context_create($options);
$raw = @file_get_contents($url, false, $ctx);
if ($raw === false) { echo "Request failed or empty\n"; exit(2); }
// Attempt to pretty-print JSON
$json = json_decode($raw, true);
if (json_last_error() !== JSON_ERROR_NONE) {
  echo "Invalid JSON returned:\n";
  echo $raw . "\n";
  exit(3);
}
echo "--- decoded JSON ---\n";
print_r($json);
echo "--- raw JSON ---\n";
echo $raw . "\n";
