<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    
    echo "=== VERIFICACIÓN DE IMPORTACIÓN RECIENTE ===\n\n";
    
    // 1. Buscar el pedido más reciente
    echo "1. PEDIDO MÁS RECIENTE:\n";
    $stmt = $pdo->query('
        SELECT p.*, e.code as estado_code, e.nombre as estado_nombre
        FROM so_pedido p 
        LEFT JOIN so_pedido_estado e ON e.id = p.estado_id 
        ORDER BY p.id DESC 
        LIMIT 1
    ');
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($pedido) {
        echo "  ID: {$pedido['id']}\n";
        echo "  Código: {$pedido['codigo']}\n";
        echo "  Cliente ID: {$pedido['cliente_id']}\n";
        echo "  Fecha: {$pedido['fecha_pedido']}\n";
        echo "  Estado: {$pedido['estado_code']} ({$pedido['estado_nombre']})\n";
        echo "  Import Batch: {$pedido['import_batch_id']}\n";
        echo "  Creado: {$pedido['created_at']}\n";
        
        $pedidoId = $pedido['id'];
        $pedidoCodigo = $pedido['codigo'];
        
        // 2. Verificar destinos
        echo "\n2. DESTINOS DEL PEDIDO:\n";
        $stmt = $pdo->prepare('
            SELECT d.*, dest.razon_social, dest.nombre, dest.cod
            FROM so_pedido_dest d 
            LEFT JOIN para_destinatarios dest ON dest.id = d.destinatario_id 
            WHERE d.pedido_id = ?
        ');
        $stmt->execute([$pedidoId]);
        $destinos = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($destinos as $i => $dest) {
            echo "  Destino " . ($i + 1) . ":\n";
            echo "    ID: {$dest['id']}\n";
            echo "    Destinatario: {$dest['razon_social']} | {$dest['nombre']} (Cod: {$dest['cod']})\n";
            echo "    Documento: {$dest['doc_tipo']} {$dest['doc_numero']}\n";
            
            // 3. Items de este destino
            echo "    Items:\n";
            $stmt = $pdo->prepare('
                SELECT i.*, pr.sku, pr.denominacion
                FROM so_pedido_dest_item i 
                LEFT JOIN para_productos pr ON pr.id = i.producto_id 
                WHERE i.pedido_dest_id = ?
            ');
            $stmt->execute([$dest['id']]);
            $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($items as $item) {
                echo "      - SKU: {$item['sku']} | {$item['denominacion']}\n";
                echo "        Expected: UV={$item['expected_uv']}, UC={$item['expected_uc']}\n";
                echo "        Prepared: UV={$item['prepared_uv']}, UC={$item['prepared_uc']}\n";
                echo "        Lote código: {$item['lote_codigo']}\n";
            }
        }
        
        // 4. Verificar si hay stock disponible para estos productos
        echo "\n3. VERIFICACIÓN DE STOCK DISPONIBLE:\n";
        $stmt = $pdo->prepare('
            SELECT DISTINCT i.producto_id, pr.sku, pr.denominacion
            FROM so_pedido_dest_item i 
            LEFT JOIN para_productos pr ON pr.id = i.producto_id
            JOIN so_pedido_dest d ON d.id = i.pedido_dest_id 
            WHERE d.pedido_id = ?
        ');
        $stmt->execute([$pedidoId]);
        $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($productos as $prod) {
            echo "  SKU: {$prod['sku']} ({$prod['denominacion']})\n";
            
            $stmt = $pdo->prepare('
                SELECT s.*, l.codigo as lote, pos.code as posicion
                FROM wh_stock s 
                LEFT JOIN wh_lote l ON l.id = s.lote_id 
                LEFT JOIN wh_posicion pos ON pos.id = s.posicion_id
                WHERE s.producto_id = ? AND (s.qty_uv > 0 OR s.qty_uc > 0)
                ORDER BY l.fecha_vencimiento ASC
                LIMIT 3
            ');
            $stmt->execute([$prod['producto_id']]);
            $stocks = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            if (empty($stocks)) {
                echo "    ⚠️ SIN STOCK DISPONIBLE\n";
            } else {
                foreach ($stocks as $stock) {
                    echo "    ✅ {$stock['posicion']} | Lote: {$stock['lote']} | Stock: UV={$stock['qty_uv']}, UC={$stock['qty_uc']}\n";
                }
            }
        }
        
    } else {
        echo "  ❌ No se encontraron pedidos\n";
    }
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>