<?php
require_once __DIR__ . '/../config/db.php';

$pdo = get_pdo();

$tables = $pdo->query("SHOW TABLES LIKE 'inv_%'")->fetchAll(PDO::FETCH_COLUMN);
echo "Tablas de inventario:\n";
foreach ($tables as $table) {
    echo "- $table\n";
}

// Verificar estructura
if (in_array('inv_conteo_items', $tables)) {
    echo "\n✓ inv_conteo_items existe\n";
} else {
    echo "\n✗ inv_conteo_items NO existe, creándola...\n";
    
    $sql = "CREATE TABLE `inv_conteo_items` (
      `id` bigint unsigned NOT NULL AUTO_INCREMENT,
      `conteo_id` bigint unsigned NOT NULL COMMENT 'Referencia al conteo',
      `producto_id` bigint unsigned NOT NULL COMMENT 'SKU contado',
      `lote_id` bigint unsigned DEFAULT NULL COMMENT 'Lote específico (NULL = sin lote)',
      `posicion_id` bigint unsigned DEFAULT NULL COMMENT 'Posición donde se encontró',
      `cantidad_pallets` int unsigned NOT NULL DEFAULT 0 COMMENT 'Número de pallets completos',
      `cantidad_cajas` int unsigned NOT NULL DEFAULT 0 COMMENT 'Cajas sueltas (UV)',
      `cantidad_unidades` int unsigned NOT NULL DEFAULT 0 COMMENT 'Unidades sueltas (UC)',
      `total_unidades` int unsigned NOT NULL DEFAULT 0 COMMENT 'Total convertido a unidades base',
      `unidades_por_caja` int unsigned DEFAULT NULL COMMENT 'UC por caja del producto (para cálculo)',
      `cajas_por_pallet` int unsigned DEFAULT NULL COMMENT 'Cajas por pallet del producto (para cálculo)',
      `observaciones` varchar(255) DEFAULT NULL COMMENT 'Notas sobre este item',
      `contado_por` int unsigned DEFAULT NULL COMMENT 'Usuario que realizó el conteo físico',
      `contado_at` datetime DEFAULT NULL COMMENT 'Momento del conteo',
      `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
      `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
      `deleted_at` datetime DEFAULT NULL,
      PRIMARY KEY (`id`),
      KEY `idx_conteo_items_conteo` (`conteo_id`),
      KEY `idx_conteo_items_producto` (`producto_id`),
      KEY `idx_conteo_items_lote` (`lote_id`),
      KEY `idx_conteo_items_posicion` (`posicion_id`),
      KEY `idx_conteo_items_deleted` (`deleted_at`),
      CONSTRAINT `fk_conteo_items_conteo` FOREIGN KEY (`conteo_id`) REFERENCES `inv_conteos` (`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $pdo->exec($sql);
    echo "✓ Tabla creada\n";
    
    $pdo->exec("CREATE UNIQUE INDEX `uq_conteo_producto_lote_pos` ON `inv_conteo_items` 
      (`conteo_id`, `producto_id`, `lote_id`, `posicion_id`, `deleted_at`)");
    echo "✓ Índice único creado\n";
}

echo "\n✅ Verificación completada\n";
