<?php
require_once __DIR__ . '/../config/db.php';

echo "Verificando tablas del SP...\n";
$pdo = getPDO();

$soId = 5;
$soCodigo = 'SO-20251023-162511-2';

// 1. Verificar so_pedido
echo "\n1. Tabla so_pedido:\n";
$stmt = $pdo->prepare("SELECT id, codigo FROM so_pedido WHERE id = ? OR codigo = ?");
$stmt->execute([$soId, $soCodigo]);
$pedido = $stmt->fetch(PDO::FETCH_ASSOC);
if($pedido) {
    echo "  ✓ Pedido encontrado: ID={$pedido['id']}, Codigo={$pedido['codigo']}\n";
    $pedidoId = $pedido['id'];
} else {
    echo "  ✗ Pedido no encontrado\n";
    exit(1);
}

// 2. Verificar so_pedido_dest
echo "\n2. Tabla so_pedido_dest:\n";
$stmt = $pdo->prepare("SELECT id, destinatario_id FROM so_pedido_dest WHERE pedido_id = ?");
$stmt->execute([$pedidoId]);
$dests = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "  Destinos encontrados: " . count($dests) . "\n";
foreach($dests as $dest) {
    echo "    ID: {$dest['id']}, Destinatario: {$dest['destinatario_id']}\n";
}

// 3. Verificar so_pedido_dest_item
echo "\n3. Tabla so_pedido_dest_item:\n";
if(!empty($dests)) {
    $destIds = array_column($dests, 'id');
    $placeholders = str_repeat('?,', count($destIds) - 1) . '?';
    $stmt = $pdo->prepare("
        SELECT 
            i.id, 
            i.producto_id, 
            p.sku as producto_codigo,
            p.denominacion as producto_name,
            i.expected_uc,
            i.prepared_uc,
            i.prepared_uv
        FROM so_pedido_dest_item i 
        JOIN para_productos p ON p.id = i.producto_id
        WHERE i.pedido_dest_id IN ($placeholders)
    ");
    $stmt->execute($destIds);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "  Items encontrados: " . count($items) . "\n";
    foreach($items as $item) {
        echo "    ID:{$item['id']} | {$item['producto_codigo']} | Exp:{$item['expected_uc']} | PrepUC:{$item['prepared_uc']} | PrepUV:{$item['prepared_uv']}\n";
    }
}

echo "\n¡Verificación completada!\n";
?>