<?php
use PHPUnit\Framework\TestCase;
use App\LayoutBuilder;

final class LayoutBuilderTest extends TestCase
{
    public function testGenerateSmallGrid()
    {
        $pos = LayoutBuilder::generatePositions('DEP', 1, 2, 1, 1);
        $this->assertCount(2, $pos);
        $this->assertEquals('R01-C01-N01-F01', $pos[0]['code']);
        $this->assertEquals('DEP-R01-C01-N01-F01', $pos[0]['code_full']);
        $this->assertEquals('R01-C02-N01-F01', $pos[1]['code']);
    }

    public function testLimitStopsEarly()
    {
        $pos = LayoutBuilder::generatePositions('D', 3, 3, 2, 2, 5);
        $this->assertCount(5, $pos);
        $this->assertStringStartsWith('R01', $pos[0]['code']);
    }
}
