<?php
declare(strict_types=1);

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/db.php';

try {
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $total = (int)$pdo->query("SELECT COUNT(*) FROM so_embarque_devoluciones")->fetchColumn();
    $empty = (int)$pdo->query("SELECT COUNT(*) FROM so_embarque_devoluciones WHERE factura IS NULL OR factura = ''")->fetchColumn();

    echo "total={$total}\n";
    echo "empty={$empty}\n";

    $stmt = $pdo->query("SELECT id, embarque_id, factura, sku FROM so_embarque_devoluciones ORDER BY id LIMIT 10");
    foreach ($stmt as $row) {
        echo implode(' | ', [
            $row['id'],
            $row['embarque_id'],
            $row['factura'] ?? 'NULL',
            $row['sku'] ?? 'NULL',
        ]) . "\n";
    }
} catch (Throwable $e) {
    fwrite(STDERR, 'Error: ' . $e->getMessage() . "\n");
    exit(1);
}
