<?php
require __DIR__ . '/../config/db.php';
$pdo = get_pdo();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->exec('SET NAMES utf8mb4');
$table = $argv[1] ?? '';
if ($table === '') {
    fwrite(STDERR, "Usage: php tmp/debug_table.php <table> [limit]\n");
    exit(1);
}
$limit = isset($argv[2]) ? (int)$argv[2] : 5;
$safeTable = str_replace('`', '``', $table);
$sql = sprintf('SELECT * FROM `%s` ORDER BY 1 DESC LIMIT %d', $safeTable, max(1, $limit));
$rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $row) {
    echo json_encode($row, JSON_UNESCAPED_UNICODE) . PHP_EOL;
}
