<?php
require __DIR__ . '/../config/db.php';
$pdo = get_pdo();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->exec('SET NAMES utf8mb4');
$table = $argv[1] ?? '';
if ($table === '') {
    fwrite(STDERR, "Usage: php tmp/describe_table.php <table>\n");
    exit(1);
}
$rows = $pdo->query('DESCRIBE `' . str_replace('`', '``', $table) . '`')->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $row) {
    echo json_encode($row, JSON_UNESCAPED_UNICODE) . PHP_EOL;
}
