-- MySQL dump 10.13  Distrib 8.0.30, for Win64 (x86_64)
--
-- Host: localhost    Database: sol
-- ------------------------------------------------------
-- Server version	8.0.30

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `_nums`
--

DROP TABLE IF EXISTS `_nums`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `_nums` (
  `n` int NOT NULL,
  PRIMARY KEY (`n`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inv09_lotes_map`
--

DROP TABLE IF EXISTS `inv09_lotes_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inv09_lotes_map` (
  `producto_id` bigint unsigned NOT NULL,
  `lote_id` bigint unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inv09_normalized`
--

DROP TABLE IF EXISTS `inv09_normalized`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inv09_normalized` (
  `producto_id` bigint unsigned DEFAULT NULL,
  `cajas_por_pallet` int NOT NULL DEFAULT '0',
  `unidades_por_uc` int NOT NULL DEFAULT '0',
  `pallets_final` decimal(23,0) DEFAULT NULL,
  `uc_final` bigint DEFAULT NULL,
  `uv_final` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inv09_pallet_moves`
--

DROP TABLE IF EXISTS `inv09_pallet_moves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inv09_pallet_moves` (
  `pallet_id` bigint unsigned NOT NULL DEFAULT '0',
  `producto_id` bigint unsigned DEFAULT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `cajas_por_pallet` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inv09_sp_map`
--

DROP TABLE IF EXISTS `inv09_sp_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inv09_sp_map` (
  `producto_id` bigint unsigned DEFAULT NULL,
  `pallet_id` bigint unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oper_movil_disponible`
--

DROP TABLE IF EXISTS `oper_movil_disponible`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oper_movil_disponible` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `fecha` date NOT NULL,
  `movil_id` int unsigned NOT NULL,
  `disponible` tinyint(1) NOT NULL DEFAULT '1',
  `ventana_ini` time DEFAULT NULL,
  `ventana_fin` time DEFAULT NULL,
  `llegada_time` time DEFAULT NULL,
  `no_asistio` tinyint(1) NOT NULL DEFAULT '0',
  `no_asistio_by` bigint unsigned DEFAULT NULL,
  `no_asistio_at` datetime DEFAULT NULL,
  `no_utilizado` tinyint(1) NOT NULL DEFAULT '0',
  `no_utilizado_by` bigint unsigned DEFAULT NULL,
  `no_utilizado_at` datetime DEFAULT NULL,
  `notas` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_fecha_movil` (`fecha`,`movil_id`),
  KEY `idx_fecha` (`fecha`),
  KEY `idx_movil` (`movil_id`),
  CONSTRAINT `fk_oper_movil_disponible_movil` FOREIGN KEY (`movil_id`) REFERENCES `para_moviles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_choferes`
--

DROP TABLE IF EXISTS `para_choferes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_choferes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(120) NOT NULL,
  `documento` varchar(40) DEFAULT NULL,
  `telefono` varchar(40) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_ciudades`
--

DROP TABLE IF EXISTS `para_ciudades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_ciudades` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_clases`
--

DROP TABLE IF EXISTS `para_clases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_clases` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(120) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_para_clases_nombre` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_clientes`
--

DROP TABLE IF EXISTS `para_clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_clientes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `razon_social` varchar(255) NOT NULL,
  `ruc` varchar(64) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_paracli_created_by` (`created_by`),
  CONSTRAINT `fk_paracli_created_by` FOREIGN KEY (`created_by`) REFERENCES `sys_users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_codigo_tipos`
--

DROP TABLE IF EXISTS `para_codigo_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_codigo_tipos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(32) NOT NULL,
  `nombre` varchar(120) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_para_codigo_tipos_codigo` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_destinatarios`
--

DROP TABLE IF EXISTS `para_destinatarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_destinatarios` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cod` varchar(20) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `fantasia` varchar(100) NOT NULL,
  `ruc` varchar(20) DEFAULT NULL,
  `razon_social` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `telefono` int NOT NULL,
  `direccion` text NOT NULL,
  `ciudad_id` int NOT NULL,
  `contacto_destinatario` text,
  `contacto_vendedor` text,
  `cliente_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_dest_cliente` (`cliente_id`),
  CONSTRAINT `fk_dest_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `para_clientes` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_devolucion_motivo`
--

DROP TABLE IF EXISTS `para_devolucion_motivo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_devolucion_motivo` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_dev_motivo` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_grupos`
--

DROP TABLE IF EXISTS `para_grupos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_grupos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(120) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_para_grupos_nombre` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_metodos_rotacion`
--

DROP TABLE IF EXISTS `para_metodos_rotacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_metodos_rotacion` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(32) NOT NULL,
  `nombre` varchar(120) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_para_metrot_codigo` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_movil_tipos`
--

DROP TABLE IF EXISTS `para_movil_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_movil_tipos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_moviles`
--

DROP TABLE IF EXISTS `para_moviles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_moviles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `chapa` text NOT NULL,
  `tipo_id` int NOT NULL,
  `gps` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `transportadora_id` int DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_pack_tipos`
--

DROP TABLE IF EXISTS `para_pack_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_pack_tipos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(16) NOT NULL,
  `nombre` varchar(64) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_para_pack_tipos_codigo` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_producto_codigos`
--

DROP TABLE IF EXISTS `para_producto_codigos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_producto_codigos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `tipo_codigo_id` bigint unsigned NOT NULL,
  `valor` varchar(128) NOT NULL,
  `cliente_id` bigint unsigned DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_paraprocod_prod_tipo_valor` (`producto_id`,`tipo_codigo_id`,`valor`),
  KEY `idx_paraprocod_valor` (`valor`),
  KEY `fk_paraprocod_tipo` (`tipo_codigo_id`),
  KEY `fk_paraprocod_cliente` (`cliente_id`),
  CONSTRAINT `fk_paraprocod_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `para_clientes` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_paraprocod_producto` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_paraprocod_tipo` FOREIGN KEY (`tipo_codigo_id`) REFERENCES `para_codigo_tipos` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_producto_pack`
--

DROP TABLE IF EXISTS `para_producto_pack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_producto_pack` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `tipo_pack_id` bigint unsigned NOT NULL,
  `largo_cm` decimal(9,2) NOT NULL DEFAULT '0.00',
  `ancho_cm` decimal(9,2) NOT NULL DEFAULT '0.00',
  `alto_cm` decimal(9,2) NOT NULL DEFAULT '0.00',
  `peso_neto_kg` decimal(12,3) NOT NULL DEFAULT '0.000',
  `peso_bruto_kg` decimal(12,3) NOT NULL DEFAULT '0.000',
  `volumen_m3` decimal(14,6) GENERATED ALWAYS AS ((((`largo_cm` * `ancho_cm`) * `alto_cm`) / 1000000)) STORED,
  `unidades_por_uc` int unsigned DEFAULT NULL,
  `precio_uc_efectivo_gs` decimal(18,2) DEFAULT NULL,
  `descripcion` text,
  `peso_estandar_kg` decimal(12,3) DEFAULT NULL,
  `peso_3sigma_inf_kg` decimal(12,3) DEFAULT NULL,
  `peso_3sigma_sup_kg` decimal(12,3) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  `precio_uv_efectivo_gs` decimal(18,2) GENERATED ALWAYS AS ((case when ((`unidades_por_uc` is null) or (`unidades_por_uc` = 0) or (`precio_uc_efectivo_gs` is null)) then NULL else round((`precio_uc_efectivo_gs` / `unidades_por_uc`),2) end)) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_parapack_prod_tipo` (`producto_id`,`tipo_pack_id`),
  KEY `idx_parapack_tipo` (`tipo_pack_id`),
  CONSTRAINT `fk_parapack_producto` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_parapack_tipo` FOREIGN KEY (`tipo_pack_id`) REFERENCES `para_pack_tipos` (`id`) ON DELETE RESTRICT ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=573 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_producto_paletizado`
--

DROP TABLE IF EXISTS `para_producto_paletizado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_producto_paletizado` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `cajas_por_capa` int unsigned NOT NULL DEFAULT '0',
  `capas_por_pallet` int unsigned NOT NULL DEFAULT '0',
  `uv_por_capa` int unsigned DEFAULT NULL,
  `cajas_por_pallet` int unsigned GENERATED ALWAYS AS ((`cajas_por_capa` * `capas_por_pallet`)) STORED,
  `uc_por_caja` int unsigned DEFAULT NULL,
  `altura_pallet_cm` decimal(9,2) NOT NULL DEFAULT '0.00',
  `peso_pallet_vacio_kg` decimal(12,3) NOT NULL DEFAULT '0.000',
  `peso_maximo_pallet_kg` decimal(12,3) NOT NULL DEFAULT '0.000',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ppp_producto` (`producto_id`) USING BTREE,
  CONSTRAINT `fk_parapallet_producto` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=257 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_productos`
--

DROP TABLE IF EXISTS `para_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_productos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `operativa_id` int DEFAULT NULL,
  `cliente_id` bigint unsigned DEFAULT NULL,
  `sku` varchar(64) NOT NULL,
  `denominacion` varchar(255) NOT NULL,
  `clase_id` bigint unsigned DEFAULT NULL,
  `grupo_id` bigint unsigned DEFAULT NULL,
  `marca` varchar(120) DEFAULT NULL,
  `material` varchar(120) DEFAULT NULL,
  `metodo_rotacion_id` bigint unsigned DEFAULT NULL,
  `conservacion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `color_web` char(6) DEFAULT NULL,
  `stock_min_default` int unsigned NOT NULL DEFAULT '0',
  `vida_util_dias` int unsigned DEFAULT NULL,
  `venc_amarillo_dias` int unsigned DEFAULT NULL,
  `venc_rojo_dias` int unsigned DEFAULT NULL,
  `estadia_amarillo_dias` int unsigned DEFAULT NULL,
  `estadia_rojo_dias` int unsigned DEFAULT NULL,
  `img_main` varchar(512) DEFAULT NULL,
  `img_uc` varchar(512) DEFAULT NULL,
  `img_uv` varchar(512) DEFAULT NULL,
  `precio_unit_efectivo_gs` decimal(18,2) DEFAULT NULL,
  `nota` text,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
  `updated_at` datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3) ON UPDATE CURRENT_TIMESTAMP(3),
  `deleted_at` datetime(3) DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_para_productos_oper_sku` (`operativa_id`,`sku`),
  KEY `idx_paraprod_clase` (`clase_id`),
  KEY `idx_paraprod_grupo` (`grupo_id`),
  KEY `idx_paraprod_activo` (`activo`),
  KEY `idx_paraprod_sku` (`sku`),
  KEY `fk_paraprod_cliente` (`cliente_id`),
  KEY `fk_paraprod_metrot` (`metodo_rotacion_id`),
  CONSTRAINT `fk_paraprod_clase` FOREIGN KEY (`clase_id`) REFERENCES `para_clases` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_paraprod_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `para_clientes` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_paraprod_grupo` FOREIGN KEY (`grupo_id`) REFERENCES `para_grupos` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_paraprod_metrot` FOREIGN KEY (`metodo_rotacion_id`) REFERENCES `para_metodos_rotacion` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_paraprod_operativa` FOREIGN KEY (`operativa_id`) REFERENCES `sys_operativas` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `para_transportadoras`
--

DROP TABLE IF EXISTS `para_transportadoras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `para_transportadoras` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_chofer`
--

DROP TABLE IF EXISTS `pl_chofer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_chofer` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `doc_numero` varchar(50) DEFAULT NULL,
  `licencia` varchar(50) DEFAULT NULL,
  `empresa` varchar(100) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_numero` (`doc_numero`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_import_batch`
--

DROP TABLE IF EXISTS `pl_import_batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_import_batch` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tipo` enum('PACKINGLIST') NOT NULL DEFAULT 'PACKINGLIST',
  `filename` varchar(255) DEFAULT NULL,
  `sheet_name` varchar(128) DEFAULT NULL,
  `imported_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int unsigned DEFAULT NULL,
  `rows_total` int unsigned DEFAULT NULL,
  `rows_ok` int unsigned DEFAULT NULL,
  `rows_error` int unsigned DEFAULT NULL,
  `log` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_import_row`
--

DROP TABLE IF EXISTS `pl_import_row`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_import_row` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `batch_id` bigint unsigned NOT NULL,
  `rownum` int unsigned NOT NULL,
  `raw` json DEFAULT NULL,
  `status` enum('OK','ERROR','SKIPPED') NOT NULL DEFAULT 'OK',
  `error_msg` varchar(255) DEFAULT NULL,
  `packinglist_id` bigint unsigned DEFAULT NULL,
  `item_id` bigint unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_improw_batch` (`batch_id`),
  KEY `idx_improw_pl` (`packinglist_id`,`item_id`),
  CONSTRAINT `fk_improw_batch` FOREIGN KEY (`batch_id`) REFERENCES `pl_import_batch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_ingreso`
--

DROP TABLE IF EXISTS `pl_ingreso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_ingreso` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `packinglist_id` bigint unsigned NOT NULL,
  `deposito_id` int unsigned NOT NULL,
  `movil_id` int unsigned DEFAULT NULL,
  `chofer_id` int unsigned DEFAULT NULL,
  `fecha_ingreso` date NOT NULL,
  `llegada_at` time DEFAULT NULL,
  `descarga_inicio_at` time DEFAULT NULL,
  `descarga_fin_at` time DEFAULT NULL,
  `operarios_cant` smallint unsigned DEFAULT NULL,
  `doc_tipo` enum('FACTURA','REMITO','OTRO') DEFAULT NULL,
  `doc_numero` varchar(64) DEFAULT NULL,
  `doc_fecha` date DEFAULT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_ing_pl` (`packinglist_id`),
  KEY `fk_ing_dep` (`deposito_id`),
  KEY `fk_ing_movil` (`movil_id`),
  KEY `fk_ing_chofer` (`chofer_id`),
  KEY `idx_ing_tiempos` (`fecha_ingreso`,`descarga_inicio_at`,`descarga_fin_at`),
  CONSTRAINT `fk_ing_chofer` FOREIGN KEY (`chofer_id`) REFERENCES `pl_chofer` (`id`),
  CONSTRAINT `fk_ing_dep` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`),
  CONSTRAINT `fk_ing_movil` FOREIGN KEY (`movil_id`) REFERENCES `pl_movil` (`id`),
  CONSTRAINT `fk_ing_pl` FOREIGN KEY (`packinglist_id`) REFERENCES `pl_packinglist` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_movil`
--

DROP TABLE IF EXISTS `pl_movil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_movil` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `patente` varchar(20) NOT NULL,
  `empresa` varchar(100) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_movil_patente` (`patente`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_packinglist`
--

DROP TABLE IF EXISTS `pl_packinglist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_packinglist` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(64) NOT NULL,
  `cliente_ref` varchar(64) DEFAULT NULL,
  `cliente_id` bigint unsigned DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `estado` enum('CREADO','IMPORTADO','EN_DESCARGA','DESCARGADO','VALIDADO','CERRADO') NOT NULL DEFAULT 'CREADO',
  `checked_all` tinyint(1) NOT NULL DEFAULT '0',
  `obs` varchar(255) DEFAULT NULL,
  `import_batch_id` bigint unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_pl_codigo` (`codigo`),
  KEY `idx_pl_estado` (`estado`),
  KEY `idx_pl_cliente_id` (`cliente_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_packinglist_item`
--

DROP TABLE IF EXISTS `pl_packinglist_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_packinglist_item` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `packinglist_id` bigint unsigned NOT NULL,
  `sku_cliente` varchar(64) NOT NULL,
  `producto_id` bigint unsigned DEFAULT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `lote_codigo` varchar(64) DEFAULT NULL,
  `fecha_produccion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `expected_uv` int unsigned NOT NULL DEFAULT '0',
  `expected_uc` int unsigned NOT NULL DEFAULT '0',
  `received_uv` int unsigned NOT NULL DEFAULT '0',
  `received_uc` int unsigned NOT NULL DEFAULT '0',
  `diff_uv` int GENERATED ALWAYS AS ((cast(`expected_uv` as signed) - cast(`received_uv` as signed))) VIRTUAL,
  `diff_uc` int GENERATED ALWAYS AS ((cast(`expected_uc` as signed) - cast(`received_uc` as signed))) VIRTUAL,
  `checked_item` tinyint(1) NOT NULL DEFAULT '0',
  `obs` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_plitem_prod` (`producto_id`),
  KEY `idx_plitem_sku` (`sku_cliente`),
  KEY `idx_plitem_pl` (`packinglist_id`),
  CONSTRAINT `fk_plitem_pl` FOREIGN KEY (`packinglist_id`) REFERENCES `pl_packinglist` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_producto_alias`
--

DROP TABLE IF EXISTS `pl_producto_alias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_producto_alias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cliente_id` bigint unsigned DEFAULT NULL,
  `sku_cliente` varchar(128) NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_cliente_sku` (`cliente_id`,`sku_cliente`),
  UNIQUE KEY `uk_alias_cli_id` (`cliente_id`,`sku_cliente`),
  KEY `fk_alias_producto` (`producto_id`),
  CONSTRAINT `fk_alias_producto` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pl_rcv_link`
--

DROP TABLE IF EXISTS `pl_rcv_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_rcv_link` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `packinglist_id` bigint unsigned NOT NULL,
  `pl_item_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `pallet_id` bigint unsigned NOT NULL,
  `move_id` bigint unsigned DEFAULT NULL,
  `uv_cajas` int unsigned NOT NULL DEFAULT '0',
  `uc_unidades` int unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_pl_link` (`pl_item_id`,`pallet_id`,`producto_id`,`lote_id`),
  KEY `fk_rcv_plitem` (`pl_item_id`),
  KEY `fk_rcv_lote` (`lote_id`),
  KEY `fk_rcv_move` (`move_id`),
  KEY `idx_rcv_pl` (`packinglist_id`,`pl_item_id`),
  KEY `idx_rcv_pallet` (`pallet_id`),
  KEY `idx_rcv_prod` (`producto_id`,`lote_id`),
  CONSTRAINT `fk_rcv_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_rcv_move` FOREIGN KEY (`move_id`) REFERENCES `wh_move` (`id`),
  CONSTRAINT `fk_rcv_pallet` FOREIGN KEY (`pallet_id`) REFERENCES `wh_pallet` (`id`),
  CONSTRAINT `fk_rcv_pl` FOREIGN KEY (`packinglist_id`) REFERENCES `pl_packinglist` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rcv_plitem` FOREIGN KEY (`pl_item_id`) REFERENCES `pl_packinglist_item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rcv_prod` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_VALUE_ON_ZERO' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `trg_pl_rcv_link_ai` AFTER INSERT ON `pl_rcv_link` FOR EACH ROW BEGIN
  UPDATE pl_packinglist_item i
     SET i.received_uv = (
           SELECT COALESCE(SUM(uv_cajas),0)
             FROM pl_rcv_link l
            WHERE l.pl_item_id = NEW.pl_item_id
         ),
         i.received_uc = (
           SELECT COALESCE(SUM(uc_unidades),0)
             FROM pl_rcv_link l
            WHERE l.pl_item_id = NEW.pl_item_id
         )
   WHERE i.id = NEW.pl_item_id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_VALUE_ON_ZERO' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `trg_pl_rcv_link_au` AFTER UPDATE ON `pl_rcv_link` FOR EACH ROW BEGIN
  -- Recalcular para el ítem afectado (puede cambiar pl_item_id en un UPDATE)
  UPDATE pl_packinglist_item i
     SET i.received_uv = (
           SELECT COALESCE(SUM(uv_cajas),0)
             FROM pl_rcv_link l
            WHERE l.pl_item_id = NEW.pl_item_id
         ),
         i.received_uc = (
           SELECT COALESCE(SUM(uc_unidades),0)
             FROM pl_rcv_link l
            WHERE l.pl_item_id = NEW.pl_item_id
         )
   WHERE i.id = NEW.pl_item_id;

  IF OLD.pl_item_id <> NEW.pl_item_id THEN
    UPDATE pl_packinglist_item i
       SET i.received_uv = (
             SELECT COALESCE(SUM(uv_cajas),0)
               FROM pl_rcv_link l
              WHERE l.pl_item_id = OLD.pl_item_id
           ),
           i.received_uc = (
             SELECT COALESCE(SUM(uc_unidades),0)
               FROM pl_rcv_link l
              WHERE l.pl_item_id = OLD.pl_item_id
           )
     WHERE i.id = OLD.pl_item_id;
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_VALUE_ON_ZERO' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `trg_pl_rcv_link_ad` AFTER DELETE ON `pl_rcv_link` FOR EACH ROW BEGIN
  UPDATE pl_packinglist_item i
     SET i.received_uv = (
           SELECT COALESCE(SUM(uv_cajas),0)
             FROM pl_rcv_link l
            WHERE l.pl_item_id = OLD.pl_item_id
         ),
         i.received_uc = (
           SELECT COALESCE(SUM(uc_unidades),0)
             FROM pl_rcv_link l
            WHERE l.pl_item_id = OLD.pl_item_id
         )
   WHERE i.id = OLD.pl_item_id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `pl_sources`
--

DROP TABLE IF EXISTS `pl_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pl_sources` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(80) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_devolucion`
--

DROP TABLE IF EXISTS `so_devolucion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_devolucion` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `retorno_id` bigint unsigned NOT NULL,
  `destinatario_id` bigint unsigned DEFAULT NULL,
  `doc_tipo` varchar(20) DEFAULT NULL,
  `doc_numero` varchar(64) DEFAULT NULL,
  `motivo_id` int unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `qty_pallets` int NOT NULL DEFAULT '0',
  `qty_uv` int NOT NULL DEFAULT '0',
  `qty_uc` int NOT NULL DEFAULT '0',
  `responsable_user_id` int unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sodev_dest` (`destinatario_id`),
  KEY `fk_sodev_mot` (`motivo_id`),
  KEY `fk_sodev_prod` (`producto_id`),
  KEY `fk_sodev_lote` (`lote_id`),
  KEY `idx_sodev_lookup` (`retorno_id`,`producto_id`,`lote_id`),
  CONSTRAINT `fk_sodev_dest` FOREIGN KEY (`destinatario_id`) REFERENCES `para_destinatarios` (`id`),
  CONSTRAINT `fk_sodev_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_sodev_mot` FOREIGN KEY (`motivo_id`) REFERENCES `para_devolucion_motivo` (`id`),
  CONSTRAINT `fk_sodev_prod` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`),
  CONSTRAINT `fk_sodev_ret` FOREIGN KEY (`retorno_id`) REFERENCES `so_retorno` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_embarque`
--

DROP TABLE IF EXISTS `so_embarque`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_embarque` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(64) NOT NULL,
  `deposito_id` int unsigned NOT NULL,
  `movil_id` int unsigned DEFAULT NULL,
  `chofer_id` int unsigned DEFAULT NULL,
  `estado_id` int unsigned NOT NULL,
  `creado_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `llegada_at` datetime DEFAULT NULL,
  `carga_fecha` date DEFAULT NULL,
  `carga_inicio_at` datetime DEFAULT NULL,
  `carga_fin_at` datetime DEFAULT NULL,
  `ayudantes_cant` smallint unsigned DEFAULT NULL,
  `salida_at` datetime DEFAULT NULL,
  `ticket_porteria` varchar(64) DEFAULT NULL,
  `ticket_bascula` varchar(64) DEFAULT NULL,
  `km_inicial` int DEFAULT NULL,
  `temp_salida_c` decimal(5,2) DEFAULT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_so_emb_codigo` (`codigo`),
  KEY `fk_soemb_dep` (`deposito_id`),
  KEY `fk_soemb_movil` (`movil_id`),
  KEY `fk_soemb_cho` (`chofer_id`),
  KEY `fk_soemb_est` (`estado_id`),
  CONSTRAINT `fk_soemb_cho` FOREIGN KEY (`chofer_id`) REFERENCES `para_choferes` (`id`),
  CONSTRAINT `fk_soemb_dep` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`),
  CONSTRAINT `fk_soemb_est` FOREIGN KEY (`estado_id`) REFERENCES `so_embarque_estado` (`id`),
  CONSTRAINT `fk_soemb_movil` FOREIGN KEY (`movil_id`) REFERENCES `para_moviles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_embarque_estado`
--

DROP TABLE IF EXISTS `so_embarque_estado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_embarque_estado` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `orden` tinyint unsigned NOT NULL DEFAULT '1',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_so_emb_estado` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_embarque_parada`
--

DROP TABLE IF EXISTS `so_embarque_parada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_embarque_parada` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `embarque_id` bigint unsigned NOT NULL,
  `destinatario_id` bigint unsigned NOT NULL,
  `pedido_dest_id` bigint unsigned DEFAULT NULL,
  `orden` int unsigned NOT NULL DEFAULT '1',
  `km_llegada` int DEFAULT NULL,
  `hora_llegada` datetime DEFAULT NULL,
  `hora_inicio_descarga` datetime DEFAULT NULL,
  `hora_fin_descarga` datetime DEFAULT NULL,
  `hora_fin_inspeccion` datetime DEFAULT NULL,
  `hora_salida` datetime DEFAULT NULL,
  `temp_descarga_c` decimal(5,2) DEFAULT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sopar_dest` (`destinatario_id`),
  KEY `fk_sopar_ped` (`pedido_dest_id`),
  KEY `idx_sopar_route` (`embarque_id`,`orden`),
  CONSTRAINT `fk_sopar_dest` FOREIGN KEY (`destinatario_id`) REFERENCES `para_destinatarios` (`id`),
  CONSTRAINT `fk_sopar_emb` FOREIGN KEY (`embarque_id`) REFERENCES `so_embarque` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sopar_ped` FOREIGN KEY (`pedido_dest_id`) REFERENCES `so_pedido_dest` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_embarque_pre`
--

DROP TABLE IF EXISTS `so_embarque_pre`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_embarque_pre` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `embarque_id` bigint unsigned NOT NULL,
  `preembarque_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_soembpre` (`embarque_id`,`preembarque_id`),
  KEY `fk_soembpre_pre` (`preembarque_id`),
  CONSTRAINT `fk_soembpre_emb` FOREIGN KEY (`embarque_id`) REFERENCES `so_embarque` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_soembpre_pre` FOREIGN KEY (`preembarque_id`) REFERENCES `so_preembarque` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_embarque_seguimiento_dest`
--

DROP TABLE IF EXISTS `so_embarque_seguimiento_dest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_embarque_seguimiento_dest` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `embarque_id` int unsigned NOT NULL,
  `destinatario_id` int unsigned NOT NULL,
  `inicio_carga` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fin_carga` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `km_inicial` int DEFAULT NULL,
  `km_llegada` int DEFAULT NULL,
  `hr_llegada` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hr_inicio` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `espera_descargar` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hr_termino` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tiempo_descarga` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hr_salida` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tiempo_control` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tiempo_total` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_carga` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salida_camara` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `temp_carga_c` decimal(5,2) DEFAULT NULL,
  `temp_desc_c` decimal(5,2) DEFAULT NULL,
  `aviso_quien` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `aviso_hora` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `problema` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_emb_dest` (`embarque_id`,`destinatario_id`),
  KEY `idx_embarque` (`embarque_id`),
  KEY `idx_destinatario` (`destinatario_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_import_batch`
--

DROP TABLE IF EXISTS `so_import_batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_import_batch` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(32) NOT NULL DEFAULT 'PEDIDO_SALIDA',
  `filename` varchar(255) DEFAULT NULL,
  `sheet_name` varchar(128) DEFAULT NULL,
  `rows_total` int unsigned DEFAULT NULL,
  `rows_ok` int unsigned DEFAULT NULL,
  `rows_error` int unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_import_row`
--

DROP TABLE IF EXISTS `so_import_row`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_import_row` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `batch_id` bigint unsigned NOT NULL,
  `rownum` int unsigned NOT NULL,
  `raw` json NOT NULL,
  `status` enum('NEW','OK','ERROR') NOT NULL DEFAULT 'NEW',
  `error_msg` varchar(255) DEFAULT NULL,
  `pedido_id` bigint unsigned DEFAULT NULL,
  `pedido_dest_id` bigint unsigned DEFAULT NULL,
  `item_id` bigint unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_soimp_batch` (`batch_id`,`rownum`),
  CONSTRAINT `fk_soimp_batch` FOREIGN KEY (`batch_id`) REFERENCES `so_import_batch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_parada_doc`
--

DROP TABLE IF EXISTS `so_parada_doc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_parada_doc` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parada_id` bigint unsigned NOT NULL,
  `doc_tipo` varchar(20) NOT NULL,
  `doc_numero` varchar(64) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_sopardoc` (`parada_id`,`doc_tipo`,`doc_numero`),
  CONSTRAINT `fk_sopardoc_par` FOREIGN KEY (`parada_id`) REFERENCES `so_embarque_parada` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_pedido`
--

DROP TABLE IF EXISTS `so_pedido`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_pedido` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(64) NOT NULL,
  `cliente_ref` varchar(64) DEFAULT NULL,
  `cliente_id` bigint unsigned DEFAULT NULL,
  `fecha_pedido` date NOT NULL,
  `estado_id` int unsigned NOT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `import_batch_id` bigint unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_soped_codigo` (`codigo`),
  KEY `fk_soped_estado` (`estado_id`),
  KEY `fk_soped_batch` (`import_batch_id`),
  CONSTRAINT `fk_soped_batch` FOREIGN KEY (`import_batch_id`) REFERENCES `so_import_batch` (`id`),
  CONSTRAINT `fk_soped_estado` FOREIGN KEY (`estado_id`) REFERENCES `so_pedido_estado` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_pedido_dest`
--

DROP TABLE IF EXISTS `so_pedido_dest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_pedido_dest` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `destinatario_id` bigint unsigned NOT NULL,
  `doc_tipo` varchar(20) DEFAULT NULL,
  `doc_numero` varchar(64) DEFAULT NULL,
  `nota` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sopedest_ped` (`pedido_id`),
  KEY `fk_sopedest_dest` (`destinatario_id`),
  CONSTRAINT `fk_sopedest_dest` FOREIGN KEY (`destinatario_id`) REFERENCES `para_destinatarios` (`id`),
  CONSTRAINT `fk_sopedest_ped` FOREIGN KEY (`pedido_id`) REFERENCES `so_pedido` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_pedido_dest_item`
--

DROP TABLE IF EXISTS `so_pedido_dest_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_pedido_dest_item` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_dest_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `lote_codigo` varchar(64) DEFAULT NULL,
  `expected_uv` int NOT NULL DEFAULT '0',
  `expected_uc` int NOT NULL DEFAULT '0',
  `prepared_uv` int NOT NULL DEFAULT '0',
  `prepared_uc` int NOT NULL DEFAULT '0',
  `shipped_uv` int NOT NULL DEFAULT '0',
  `shipped_uc` int NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sopdi_prod` (`producto_id`),
  KEY `idx_sopdi_key` (`pedido_dest_id`,`producto_id`,`lote_codigo`),
  KEY `ix_so_pedido_dest_item_ped_prod_lote` (`pedido_dest_id`,`producto_id`,`lote_codigo`),
  CONSTRAINT `fk_sopdi_dest` FOREIGN KEY (`pedido_dest_id`) REFERENCES `so_pedido_dest` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sopdi_prod` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_pedido_estado`
--

DROP TABLE IF EXISTS `so_pedido_estado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_pedido_estado` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `orden` tinyint unsigned NOT NULL DEFAULT '1',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_so_ped_estado` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_pre_pick`
--

DROP TABLE IF EXISTS `so_pre_pick`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_pre_pick` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `preembarque_id` bigint unsigned NOT NULL,
  `pedido_dest_item_id` bigint unsigned NOT NULL,
  `from_pos_id` bigint unsigned NOT NULL,
  `to_pos_id` bigint unsigned DEFAULT NULL,
  `pallet_id` bigint unsigned DEFAULT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `uv_cajas` int NOT NULL DEFAULT '0',
  `uc_unidades` int NOT NULL DEFAULT '0',
  `creado_por` int unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_spk_pre` (`preembarque_id`),
  KEY `fk_spk_item` (`pedido_dest_item_id`),
  KEY `fk_spk_from` (`from_pos_id`),
  KEY `fk_spk_to` (`to_pos_id`),
  KEY `fk_spk_pal` (`pallet_id`),
  KEY `fk_spk_lote` (`lote_id`),
  CONSTRAINT `fk_spk_from` FOREIGN KEY (`from_pos_id`) REFERENCES `wh_posicion` (`id`),
  CONSTRAINT `fk_spk_item` FOREIGN KEY (`pedido_dest_item_id`) REFERENCES `so_pedido_dest_item` (`id`),
  CONSTRAINT `fk_spk_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_spk_pal` FOREIGN KEY (`pallet_id`) REFERENCES `wh_pallet` (`id`),
  CONSTRAINT `fk_spk_pre` FOREIGN KEY (`preembarque_id`) REFERENCES `so_preembarque` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_spk_to` FOREIGN KEY (`to_pos_id`) REFERENCES `wh_posicion` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_VALUE_ON_ZERO' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `trg_so_pre_pick_ai` AFTER INSERT ON `so_pre_pick` FOR EACH ROW BEGIN
  UPDATE so_pedido_dest_item
     SET prepared_uv = LEAST(expected_uv, prepared_uv + COALESCE(NEW.uv_cajas,0)),
         prepared_uc = LEAST(expected_uc, prepared_uc + COALESCE(NEW.uc_unidades,0))
   WHERE id = NEW.pedido_dest_item_id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `so_pre_tarea`
--

DROP TABLE IF EXISTS `so_pre_tarea`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_pre_tarea` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `preembarque_id` bigint unsigned NOT NULL,
  `tipo` enum('MONTACARGA','PREPARACION','CONTROL') NOT NULL,
  `responsable_user_id` int unsigned DEFAULT NULL,
  `inicio_at` datetime DEFAULT NULL,
  `fin_at` datetime DEFAULT NULL,
  `foto_url` varchar(255) DEFAULT NULL,
  `nota` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_so_pret_tipo` (`preembarque_id`,`tipo`),
  CONSTRAINT `fk_so_pret_pre` FOREIGN KEY (`preembarque_id`) REFERENCES `so_preembarque` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_preembarque`
--

DROP TABLE IF EXISTS `so_preembarque`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_preembarque` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(64) NOT NULL,
  `pedido_id` bigint unsigned NOT NULL,
  `deposito_id` int unsigned NOT NULL,
  `estado_id` int unsigned NOT NULL,
  `zona_posicion_id` bigint unsigned DEFAULT NULL,
  `montacarguista_user_id` int unsigned DEFAULT NULL,
  `asignado_at` datetime DEFAULT NULL,
  `inicio_at` datetime DEFAULT NULL,
  `fin_at` datetime DEFAULT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_so_pre_codigo` (`codigo`),
  KEY `fk_so_pre_ped` (`pedido_id`),
  KEY `fk_so_pre_dep` (`deposito_id`),
  KEY `fk_so_pre_est` (`estado_id`),
  KEY `fk_so_pre_pos` (`zona_posicion_id`),
  CONSTRAINT `fk_so_pre_dep` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`),
  CONSTRAINT `fk_so_pre_est` FOREIGN KEY (`estado_id`) REFERENCES `so_preembarque_estado` (`id`),
  CONSTRAINT `fk_so_pre_ped` FOREIGN KEY (`pedido_id`) REFERENCES `so_pedido` (`id`),
  CONSTRAINT `fk_so_pre_pos` FOREIGN KEY (`zona_posicion_id`) REFERENCES `wh_posicion` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_preembarque_estado`
--

DROP TABLE IF EXISTS `so_preembarque_estado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_preembarque_estado` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `orden` tinyint unsigned NOT NULL DEFAULT '1',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_so_pre_estado` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_preparar_auto_log`
--

DROP TABLE IF EXISTS `so_preparar_auto_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_preparar_auto_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ts` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pedido_codigo` varchar(64) DEFAULT NULL,
  `pedido_id` bigint unsigned DEFAULT NULL,
  `pre_id` bigint unsigned DEFAULT NULL,
  `fase` varchar(20) DEFAULT NULL,
  `item_id` bigint unsigned DEFAULT NULL,
  `producto_id` bigint unsigned DEFAULT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `lote_code` varchar(64) DEFAULT NULL,
  `from_pos_id` bigint unsigned DEFAULT NULL,
  `to_pos_id` bigint unsigned DEFAULT NULL,
  `pallet_id` bigint unsigned DEFAULT NULL,
  `take_uv` int DEFAULT NULL,
  `take_uc` int DEFAULT NULL,
  `need_uv_post` int DEFAULT NULL,
  `need_uc_post` int DEFAULT NULL,
  `venc` date DEFAULT NULL,
  `msg` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_prelog_ped` (`pedido_id`),
  KEY `idx_prelog_pre` (`pre_id`),
  KEY `idx_prelog_ts` (`ts`)
) ENGINE=InnoDB AUTO_INCREMENT=35211 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_retorno`
--

DROP TABLE IF EXISTS `so_retorno`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_retorno` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `embarque_id` bigint unsigned NOT NULL,
  `llegada_at` datetime NOT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_soret_emb` (`embarque_id`),
  CONSTRAINT `fk_soret_emb` FOREIGN KEY (`embarque_id`) REFERENCES `so_embarque` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `so_ship_link`
--

DROP TABLE IF EXISTS `so_ship_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `so_ship_link` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_dest_item_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `pallet_id` bigint unsigned DEFAULT NULL,
  `move_id` bigint unsigned DEFAULT NULL,
  `embarque_id` bigint unsigned DEFAULT NULL,
  `parada_id` bigint unsigned DEFAULT NULL,
  `uv_cajas` int NOT NULL DEFAULT '0',
  `uc_unidades` int NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sosl_prod` (`producto_id`),
  KEY `fk_sosl_lote` (`lote_id`),
  KEY `fk_sosl_pal` (`pallet_id`),
  KEY `fk_sosl_move` (`move_id`),
  KEY `fk_sosl_emb` (`embarque_id`),
  KEY `fk_sosl_par` (`parada_id`),
  KEY `idx_sosl_lookup` (`pedido_dest_item_id`,`producto_id`,`lote_id`,`created_at`),
  CONSTRAINT `fk_sosl_emb` FOREIGN KEY (`embarque_id`) REFERENCES `so_embarque` (`id`),
  CONSTRAINT `fk_sosl_item` FOREIGN KEY (`pedido_dest_item_id`) REFERENCES `so_pedido_dest_item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sosl_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_sosl_move` FOREIGN KEY (`move_id`) REFERENCES `wh_move` (`id`),
  CONSTRAINT `fk_sosl_pal` FOREIGN KEY (`pallet_id`) REFERENCES `wh_pallet` (`id`),
  CONSTRAINT `fk_sosl_par` FOREIGN KEY (`parada_id`) REFERENCES `so_embarque_parada` (`id`),
  CONSTRAINT `fk_sosl_prod` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_VALUE_ON_ZERO' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `trg_so_ship_link_ai` AFTER INSERT ON `so_ship_link` FOR EACH ROW BEGIN
  UPDATE so_pedido_dest_item
     SET shipped_uv = LEAST(expected_uv, shipped_uv + COALESCE(NEW.uv_cajas,0)),
         shipped_uc = LEAST(expected_uc, shipped_uc + COALESCE(NEW.uc_unidades,0))
   WHERE id = NEW.pedido_dest_item_id;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `sys_menu`
--

DROP TABLE IF EXISTS `sys_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_menu` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parent_id` int DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `icon` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `orden` int DEFAULT '0',
  `activo` tinyint(1) DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_sys_menu_parent` (`parent_id`),
  KEY `idx_sys_menu_activo` (`activo`,`parent_id`,`orden`)
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sys_operativas`
--

DROP TABLE IF EXISTS `sys_operativas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_operativas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(150) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sys_role`
--

DROP TABLE IF EXISTS `sys_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_role` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sys_role_rights`
--

DROP TABLE IF EXISTS `sys_role_rights`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_role_rights` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role_id` int NOT NULL,
  `menu_id` int NOT NULL,
  `can_view` tinyint(1) DEFAULT '1',
  `can_create` tinyint(1) DEFAULT '0',
  `can_edit` tinyint(1) DEFAULT '0',
  `can_delete` tinyint(1) DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_rr_role_view` (`role_id`,`can_view`,`menu_id`),
  KEY `idx_rr_menu` (`menu_id`),
  CONSTRAINT `fk_role_rights_menu` FOREIGN KEY (`menu_id`) REFERENCES `sys_menu` (`id`),
  CONSTRAINT `fk_role_rights_role` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sys_users`
--

DROP TABLE IF EXISTS `sys_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(60) NOT NULL,
  `full_name` varchar(150) NOT NULL,
  `email` varchar(150) NOT NULL,
  `pass_hash` varchar(255) NOT NULL,
  `role_code` int NOT NULL,
  `operativa_id` int DEFAULT NULL,
  `foto` varchar(150) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_username` (`username`),
  UNIQUE KEY `uq_sys_users_username` (`username`),
  UNIQUE KEY `uq_sys_users_email` (`email`),
  KEY `fk_users_operativa` (`operativa_id`),
  KEY `fk_users_role` (`role_code`),
  CONSTRAINT `fk_users_operativa` FOREIGN KEY (`operativa_id`) REFERENCES `sys_operativas` (`id`),
  CONSTRAINT `fk_users_role` FOREIGN KEY (`role_code`) REFERENCES `sys_role` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Temporary view structure for view `v_kpi_ingreso_detalle`
--

DROP TABLE IF EXISTS `v_kpi_ingreso_detalle`;
/*!50001 DROP VIEW IF EXISTS `v_kpi_ingreso_detalle`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_kpi_ingreso_detalle` AS SELECT 
 1 AS `packinglist_id`,
 1 AS `packinglist_codigo`,
 1 AS `pl_item_id`,
 1 AS `sku_cliente`,
 1 AS `producto_id`,
 1 AS `producto`,
 1 AS `desc_pl`,
 1 AS `lote_codigo`,
 1 AS `fecha_produccion`,
 1 AS `fecha_vencimiento`,
 1 AS `expected_uv`,
 1 AS `expected_uc`,
 1 AS `received_uv`,
 1 AS `received_uc`,
 1 AS `diff_uv`,
 1 AS `diff_uc`,
 1 AS `checked_item`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_kpi_ingresos_descarga`
--

DROP TABLE IF EXISTS `v_kpi_ingresos_descarga`;
/*!50001 DROP VIEW IF EXISTS `v_kpi_ingresos_descarga`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_kpi_ingresos_descarga` AS SELECT 
 1 AS `packinglist_id`,
 1 AS `packinglist_codigo`,
 1 AS `cliente_ref`,
 1 AS `pl_fecha`,
 1 AS `pl_estado`,
 1 AS `ingreso_id`,
 1 AS `fecha_ingreso`,
 1 AS `llegada_at`,
 1 AS `descarga_inicio_at`,
 1 AS `descarga_fin_at`,
 1 AS `operarios_cant`,
 1 AS `exp_uv_total`,
 1 AS `exp_uc_total`,
 1 AS `rcv_uv_total`,
 1 AS `rcv_uc_total`,
 1 AS `diff_uv_total`,
 1 AS `diff_uc_total`,
 1 AS `pallets_rcv`,
 1 AS `min_cola_llegada_a_inicio`,
 1 AS `min_descarga_efectiva`,
 1 AS `min_total_llegada_a_fin`,
 1 AS `uv_por_hora`,
 1 AS `uc_por_hora`,
 1 AS `uv_por_operario_hora`,
 1 AS `uc_por_operario_hora`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_pl_item_resumen`
--

DROP TABLE IF EXISTS `v_pl_item_resumen`;
/*!50001 DROP VIEW IF EXISTS `v_pl_item_resumen`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_pl_item_resumen` AS SELECT 
 1 AS `pl_item_id`,
 1 AS `packinglist_id`,
 1 AS `packinglist_codigo`,
 1 AS `sku_cliente`,
 1 AS `producto_id`,
 1 AS `descripcion`,
 1 AS `lote_codigo`,
 1 AS `expected_uv`,
 1 AS `expected_uc`,
 1 AS `received_uv`,
 1 AS `received_uc`,
 1 AS `diff_uv`,
 1 AS `diff_uc`,
 1 AS `checked_item`,
 1 AS `rcv_agg_uv`,
 1 AS `rcv_agg_uc`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_pl_resumen`
--

DROP TABLE IF EXISTS `v_pl_resumen`;
/*!50001 DROP VIEW IF EXISTS `v_pl_resumen`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_pl_resumen` AS SELECT 
 1 AS `packinglist_id`,
 1 AS `packinglist_codigo`,
 1 AS `cliente_ref`,
 1 AS `fecha`,
 1 AS `estado`,
 1 AS `checked_all`,
 1 AS `items_total`,
 1 AS `exp_uv_total`,
 1 AS `exp_uc_total`,
 1 AS `rcv_uv_total`,
 1 AS `rcv_uc_total`,
 1 AS `diff_uv_total`,
 1 AS `diff_uc_total`,
 1 AS `items_checked`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_so_devoluciones`
--

DROP TABLE IF EXISTS `v_so_devoluciones`;
/*!50001 DROP VIEW IF EXISTS `v_so_devoluciones`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_so_devoluciones` AS SELECT 
 1 AS `embarque_id`,
 1 AS `embarque`,
 1 AS `retorno_llegada`,
 1 AS `devolucion_id`,
 1 AS `destinatario`,
 1 AS `doc_tipo`,
 1 AS `doc_numero`,
 1 AS `motivo`,
 1 AS `producto`,
 1 AS `lote`,
 1 AS `qty_pallets`,
 1 AS `qty_uv`,
 1 AS `qty_uc`,
 1 AS `created_at`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_so_embarque_kpi`
--

DROP TABLE IF EXISTS `v_so_embarque_kpi`;
/*!50001 DROP VIEW IF EXISTS `v_so_embarque_kpi`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_so_embarque_kpi` AS SELECT 
 1 AS `embarque_id`,
 1 AS `embarque_codigo`,
 1 AS `deposito_code`,
 1 AS `creado_at`,
 1 AS `llegada_at`,
 1 AS `carga_inicio_at`,
 1 AS `carga_fin_at`,
 1 AS `salida_at`,
 1 AS `ayudantes_cant`,
 1 AS `estado`,
 1 AS `km_inicial`,
 1 AS `temp_salida_c`,
 1 AS `min_espera_carga`,
 1 AS `min_carga_efectiva`,
 1 AS `min_total_en_planta`,
 1 AS `preembarques`,
 1 AS `paradas`,
 1 AS `documentos`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_so_pedido_resumen`
--

DROP TABLE IF EXISTS `v_so_pedido_resumen`;
/*!50001 DROP VIEW IF EXISTS `v_so_pedido_resumen`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_so_pedido_resumen` AS SELECT 
 1 AS `pedido_id`,
 1 AS `pedido_codigo`,
 1 AS `fecha_pedido`,
 1 AS `pedido_estado`,
 1 AS `pedido_dest_id`,
 1 AS `destinatario`,
 1 AS `doc_tipo`,
 1 AS `doc_numero`,
 1 AS `expected_uv`,
 1 AS `expected_uc`,
 1 AS `prepared_uv`,
 1 AS `prepared_uc`,
 1 AS `shipped_uv`,
 1 AS `shipped_uc`,
 1 AS `pending_uv`,
 1 AS `pending_uc`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_so_ruteo_paradas`
--

DROP TABLE IF EXISTS `v_so_ruteo_paradas`;
/*!50001 DROP VIEW IF EXISTS `v_so_ruteo_paradas`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_so_ruteo_paradas` AS SELECT 
 1 AS `embarque`,
 1 AS `orden`,
 1 AS `destinatario`,
 1 AS `km_llegada`,
 1 AS `hora_llegada`,
 1 AS `hora_inicio_descarga`,
 1 AS `hora_fin_descarga`,
 1 AS `hora_fin_inspeccion`,
 1 AS `hora_salida`,
 1 AS `temp_descarga_c`,
 1 AS `min_espera`,
 1 AS `min_descarga`,
 1 AS `min_entrega`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_wh_moves_min`
--

DROP TABLE IF EXISTS `v_wh_moves_min`;
/*!50001 DROP VIEW IF EXISTS `v_wh_moves_min`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_wh_moves_min` AS SELECT 
 1 AS `id`,
 1 AS `tipo`,
 1 AS `motivo`,
 1 AS `deposito_id`,
 1 AS `deposito_code`,
 1 AS `pallet_id`,
 1 AS `producto_id`,
 1 AS `lote_id`,
 1 AS `from_pos_id`,
 1 AS `to_pos_id`,
 1 AS `delta_uv`,
 1 AS `delta_uc`,
 1 AS `created_at`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_wh_pallets_cuarentena`
--

DROP TABLE IF EXISTS `v_wh_pallets_cuarentena`;
/*!50001 DROP VIEW IF EXISTS `v_wh_pallets_cuarentena`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_wh_pallets_cuarentena` AS SELECT 
 1 AS `pallet`,
 1 AS `estado`,
 1 AS `deposito_code`,
 1 AS `posicion_id`,
 1 AS `posicion`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_wh_posiciones`
--

DROP TABLE IF EXISTS `v_wh_posiciones`;
/*!50001 DROP VIEW IF EXISTS `v_wh_posiciones`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_wh_posiciones` AS SELECT 
 1 AS `id`,
 1 AS `deposito_id`,
 1 AS `deposito_code`,
 1 AS `rack`,
 1 AS `columna`,
 1 AS `nivel`,
 1 AS `fondo`,
 1 AS `lado`,
 1 AS `code_full`,
 1 AS `ambiente_id`,
 1 AS `ambiente_code`,
 1 AS `ambiente_nombre`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_wh_posiciones_dep1`
--

DROP TABLE IF EXISTS `v_wh_posiciones_dep1`;
/*!50001 DROP VIEW IF EXISTS `v_wh_posiciones_dep1`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_wh_posiciones_dep1` AS SELECT 
 1 AS `id`,
 1 AS `deposito_id`,
 1 AS `rack`,
 1 AS `columna`,
 1 AS `nivel`,
 1 AS `fondo`,
 1 AS `lado`,
 1 AS `code_full`,
 1 AS `ambiente_id`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_wh_stock`
--

DROP TABLE IF EXISTS `v_wh_stock`;
/*!50001 DROP VIEW IF EXISTS `v_wh_stock`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_wh_stock` AS SELECT 
 1 AS `id`,
 1 AS `deposito_id`,
 1 AS `deposito_code`,
 1 AS `posicion_id`,
 1 AS `producto_id`,
 1 AS `lote_id`,
 1 AS `pallet_id`,
 1 AS `qty_uv`,
 1 AS `qty_uc`,
 1 AS `pickeado`,
 1 AS `updated_at`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary view structure for view `v_wh_stock_dep1`
--

DROP TABLE IF EXISTS `v_wh_stock_dep1`;
/*!50001 DROP VIEW IF EXISTS `v_wh_stock_dep1`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `v_wh_stock_dep1` AS SELECT 
 1 AS `deposito_id`,
 1 AS `posicion_id`,
 1 AS `producto_id`,
 1 AS `lote_id`,
 1 AS `pallet_id`,
 1 AS `qty_uv`,
 1 AS `qty_uc`,
 1 AS `pickeado`,
 1 AS `updated_at`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `wh_ambiente`
--

DROP TABLE IF EXISTS `wh_ambiente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_ambiente` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_ambiente_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_deposito`
--

DROP TABLE IF EXISTS `wh_deposito`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_deposito` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `operativa_id` bigint unsigned DEFAULT NULL,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `name` varchar(120) DEFAULT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `pad_lado` tinyint DEFAULT '2',
  `pad_orient` tinyint DEFAULT '1',
  `pad_rack` tinyint DEFAULT '2',
  `pad_columna` tinyint DEFAULT '2',
  `pad_nivel` tinyint DEFAULT '2',
  `pad_fondo` tinyint DEFAULT '2',
  `code_sep` char(1) DEFAULT '-',
  `orientacion` enum('N','E','W','S') NOT NULL DEFAULT 'N',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `is_active` tinyint(1) DEFAULT '1',
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_deposito_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_lote`
--

DROP TABLE IF EXISTS `wh_lote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_lote` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `codigo` varchar(64) NOT NULL,
  `fecha_produccion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_lote_prod_codigo` (`producto_id`,`codigo`),
  KEY `ix_wh_lote_prod_codigo` (`producto_id`,`codigo`),
  KEY `ix_wh_lote_prod_venc` (`producto_id`,`fecha_vencimiento`),
  CONSTRAINT `fk_lote_producto` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_move`
--

DROP TABLE IF EXISTS `wh_move`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_move` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `deposito_id` int unsigned NOT NULL,
  `tipo` enum('IN','MOVE','OUT') NOT NULL,
  `motivo` varchar(64) DEFAULT NULL,
  `pallet_id` bigint unsigned DEFAULT NULL,
  `producto_id` bigint unsigned DEFAULT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `from_pos_id` bigint unsigned DEFAULT NULL,
  `to_pos_id` bigint unsigned DEFAULT NULL,
  `delta_uv` int NOT NULL DEFAULT '0',
  `delta_uc` int NOT NULL DEFAULT '0',
  `referencia` varchar(64) DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_mv_pal` (`pallet_id`),
  KEY `fk_mv_lote` (`lote_id`),
  KEY `fk_mv_from` (`from_pos_id`),
  KEY `fk_mv_to` (`to_pos_id`),
  KEY `idx_mv_busq` (`deposito_id`,`pallet_id`,`producto_id`,`lote_id`,`created_at`),
  CONSTRAINT `fk_mv_dep` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`),
  CONSTRAINT `fk_mv_from` FOREIGN KEY (`from_pos_id`) REFERENCES `wh_posicion` (`id`),
  CONSTRAINT `fk_mv_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_mv_pal` FOREIGN KEY (`pallet_id`) REFERENCES `wh_pallet` (`id`),
  CONSTRAINT `fk_mv_to` FOREIGN KEY (`to_pos_id`) REFERENCES `wh_posicion` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=429 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_AUTO_VALUE_ON_ZERO' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `trg_wh_move_ai` AFTER INSERT ON `wh_move` FOR EACH ROW BEGIN
  CALL sp_wh_move_apply(
    NEW.tipo,
    NEW.deposito_id,
    NEW.pallet_id,
    NEW.producto_id,
    NEW.lote_id,
    NEW.from_pos_id,
    NEW.to_pos_id,
    NEW.delta_uv,
    NEW.delta_uc
  );
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `wh_move_buffer`
--

DROP TABLE IF EXISTS `wh_move_buffer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_move_buffer` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `deposito_id_from` int unsigned NOT NULL,
  `deposito_id_to` int unsigned NOT NULL,
  `from_pos_id` bigint unsigned NOT NULL,
  `to_pos_id` bigint unsigned NOT NULL,
  `pallet_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned DEFAULT NULL,
  `lote_id` bigint unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `estado` enum('PENDIENTE','CONFIRMADO','CANCELADO') DEFAULT 'PENDIENTE',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_pallet`
--

DROP TABLE IF EXISTS `wh_pallet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_pallet` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(64) NOT NULL,
  `deposito_id` int unsigned NOT NULL,
  `cliente_id` int unsigned DEFAULT NULL,
  `posicion_id` bigint unsigned DEFAULT NULL,
  `estado_id` int unsigned NOT NULL,
  `pickeado` tinyint(1) NOT NULL DEFAULT '0',
  `reservado` tinyint(1) NOT NULL DEFAULT '0',
  `peso_bruto_kg` decimal(10,3) DEFAULT NULL,
  `volumen_m3` decimal(10,3) DEFAULT NULL,
  `observacion` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_pallet_codigo` (`codigo`),
  KEY `fk_pal_deposito` (`deposito_id`),
  KEY `fk_pal_posicion` (`posicion_id`),
  KEY `fk_pal_estado` (`estado_id`),
  KEY `idx_wh_pallet_cliente` (`cliente_id`),
  CONSTRAINT `fk_pal_deposito` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`),
  CONSTRAINT `fk_pal_estado` FOREIGN KEY (`estado_id`) REFERENCES `wh_pallet_estado` (`id`),
  CONSTRAINT `fk_pal_posicion` FOREIGN KEY (`posicion_id`) REFERENCES `wh_posicion` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_pallet_estado`
--

DROP TABLE IF EXISTS `wh_pallet_estado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_pallet_estado` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `orden` tinyint unsigned NOT NULL DEFAULT '1',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_pallet_estado_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_pallet_item`
--

DROP TABLE IF EXISTS `wh_pallet_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_pallet_item` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pallet_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `lote_id` bigint unsigned NOT NULL,
  `uv_cajas` int unsigned NOT NULL DEFAULT '0',
  `uc_unidades` int unsigned NOT NULL DEFAULT '0',
  `peso_bruto_kg` decimal(10,3) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_pi_unique` (`pallet_id`,`producto_id`,`lote_id`),
  KEY `fk_pi_lote` (`lote_id`),
  KEY `fk_pi_producto` (`producto_id`),
  CONSTRAINT `fk_pi_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_pi_pallet` FOREIGN KEY (`pallet_id`) REFERENCES `wh_pallet` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pi_producto` FOREIGN KEY (`producto_id`) REFERENCES `para_productos` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_posicion`
--

DROP TABLE IF EXISTS `wh_posicion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_posicion` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `deposito_id` int unsigned NOT NULL,
  `rack` int unsigned NOT NULL,
  `columna` int unsigned NOT NULL,
  `nivel` int unsigned NOT NULL,
  `fondo` tinyint unsigned NOT NULL DEFAULT '1',
  `lado` enum('A','B') NOT NULL DEFAULT 'A',
  `orientacion` enum('N','S','E','W') NOT NULL DEFAULT 'N',
  `ambiente_id` int unsigned NOT NULL,
  `capacidad_pallets` bigint unsigned NOT NULL DEFAULT '1',
  `ocupado` tinyint(1) NOT NULL DEFAULT '0',
  `picked` tinyint(1) NOT NULL DEFAULT '0',
  `color_hex` char(7) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `code` varchar(32) NOT NULL,
  `code_full` varchar(64) NOT NULL,
  `pos_code` varchar(32) NOT NULL,
  `pos_code_full` varchar(64) NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_pos_codes` (`deposito_id`,`code`,`code_full`,`pos_code`,`pos_code_full`),
  UNIQUE KEY `uk_pos_geo` (`deposito_id`,`rack`,`columna`,`nivel`,`fondo`,`lado`,`ambiente_id`) USING BTREE,
  KEY `fk_pos_ambiente` (`ambiente_id`),
  KEY `ix_wh_posicion_dep_amb_activo` (`deposito_id`,`ambiente_id`,`activo`),
  KEY `idx_wh_posicion_dep_activo_rack` (`deposito_id`,`activo`,`rack`),
  CONSTRAINT `fk_pos_ambiente` FOREIGN KEY (`ambiente_id`) REFERENCES `wh_ambiente` (`id`),
  CONSTRAINT `fk_pos_deposito` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=812 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wh_stock`
--

DROP TABLE IF EXISTS `wh_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wh_stock` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `deposito_id` int unsigned NOT NULL,
  `posicion_id` bigint unsigned DEFAULT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `lote_id` bigint unsigned NOT NULL,
  `pallet_id` bigint unsigned DEFAULT NULL,
  `qty_uv` int NOT NULL DEFAULT '0',
  `qty_uc` int NOT NULL DEFAULT '0',
  `pickeado` tinyint(1) NOT NULL DEFAULT '0',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `posicion_id_norm` bigint unsigned GENERATED ALWAYS AS (ifnull(`posicion_id`,0)) STORED,
  `pallet_id_norm` bigint unsigned GENERATED ALWAYS AS (ifnull(`pallet_id`,0)) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_stk_key` (`deposito_id`,`posicion_id_norm`,`producto_id`,`lote_id`,`pallet_id_norm`),
  KEY `idx_stk_pos` (`deposito_id`,`posicion_id`),
  KEY `idx_stk_prod` (`producto_id`,`lote_id`),
  KEY `fk_stk_pos` (`posicion_id`),
  KEY `fk_stk_lote` (`lote_id`),
  KEY `fk_stk_pal` (`pallet_id`),
  KEY `ix_wh_stock_dep_prod_pos_lote_pall` (`deposito_id`,`producto_id`,`posicion_id`,`lote_id`,`pallet_id`),
  KEY `ix_wh_stock_dep_prod_lote_pos_pall` (`deposito_id`,`producto_id`,`lote_id`,`posicion_id`,`pallet_id`),
  CONSTRAINT `fk_stk_dep` FOREIGN KEY (`deposito_id`) REFERENCES `wh_deposito` (`id`),
  CONSTRAINT `fk_stk_lote` FOREIGN KEY (`lote_id`) REFERENCES `wh_lote` (`id`),
  CONSTRAINT `fk_stk_pal` FOREIGN KEY (`pallet_id`) REFERENCES `wh_pallet` (`id`),
  CONSTRAINT `fk_stk_pos` FOREIGN KEY (`posicion_id`) REFERENCES `wh_posicion` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=386 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Final view structure for view `v_kpi_ingreso_detalle`
--

/*!50001 DROP VIEW IF EXISTS `v_kpi_ingreso_detalle`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_kpi_ingreso_detalle` AS select `pl`.`id` AS `packinglist_id`,`pl`.`codigo` AS `packinglist_codigo`,`i`.`id` AS `pl_item_id`,`i`.`sku_cliente` AS `sku_cliente`,`i`.`producto_id` AS `producto_id`,`pr`.`denominacion` AS `producto`,`i`.`descripcion` AS `desc_pl`,`i`.`lote_codigo` AS `lote_codigo`,`i`.`fecha_produccion` AS `fecha_produccion`,`i`.`fecha_vencimiento` AS `fecha_vencimiento`,`i`.`expected_uv` AS `expected_uv`,`i`.`expected_uc` AS `expected_uc`,`i`.`received_uv` AS `received_uv`,`i`.`received_uc` AS `received_uc`,(`i`.`expected_uv` - `i`.`received_uv`) AS `diff_uv`,(`i`.`expected_uc` - `i`.`received_uc`) AS `diff_uc`,`i`.`checked_item` AS `checked_item` from ((`pl_packinglist_item` `i` join `pl_packinglist` `pl` on((`pl`.`id` = `i`.`packinglist_id`))) left join `para_productos` `pr` on((`pr`.`id` = `i`.`producto_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_kpi_ingresos_descarga`
--

/*!50001 DROP VIEW IF EXISTS `v_kpi_ingresos_descarga`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`arasa`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_kpi_ingresos_descarga` AS with `pl_last_ingreso` as (select `i`.`id` AS `id`,`i`.`packinglist_id` AS `packinglist_id`,`i`.`deposito_id` AS `deposito_id`,`i`.`movil_id` AS `movil_id`,`i`.`chofer_id` AS `chofer_id`,`m`.`chapa` AS `chapa`,`ch`.`nombre` AS `chofer_desc`,`i`.`fecha_ingreso` AS `fecha_ingreso`,`i`.`llegada_at` AS `llegada_at`,`i`.`descarga_inicio_at` AS `descarga_inicio_at`,`i`.`descarga_fin_at` AS `descarga_fin_at`,`i`.`operarios_cant` AS `operarios_cant`,`i`.`doc_tipo` AS `doc_tipo`,`i`.`doc_numero` AS `doc_numero`,`i`.`doc_fecha` AS `doc_fecha`,`i`.`observacion` AS `observacion`,`i`.`created_at` AS `created_at`,`i`.`updated_at` AS `updated_at`,row_number() OVER (PARTITION BY `i`.`packinglist_id` ORDER BY `i`.`id` desc )  AS `rn` from ((`pl_ingreso` `i` left join `para_moviles` `m` on((`m`.`id` = `i`.`movil_id`))) left join `para_choferes` `ch` on((`ch`.`id` = `i`.`chofer_id`)))), `pl_totales` as (select `pli`.`packinglist_id` AS `packinglist_id`,sum(`pli`.`expected_uv`) AS `exp_uv_total`,sum(`pli`.`expected_uc`) AS `exp_uc_total`,sum(`pli`.`received_uv`) AS `rcv_uv_total`,sum(`pli`.`received_uc`) AS `rcv_uc_total`,sum((`pli`.`expected_uv` - `pli`.`received_uv`)) AS `diff_uv_total`,sum((`pli`.`expected_uc` - `pli`.`received_uc`)) AS `diff_uc_total` from `pl_packinglist_item` `pli` group by `pli`.`packinglist_id`), `pl_pallets` as (select `l`.`packinglist_id` AS `packinglist_id`,count(distinct `l`.`pallet_id`) AS `pallets_rcv` from `pl_rcv_link` `l` group by `l`.`packinglist_id`) select `pl`.`id` AS `packinglist_id`,`pl`.`codigo` AS `packinglist_codigo`,`pl`.`cliente_ref` AS `cliente_ref`,`pl`.`fecha` AS `pl_fecha`,`pl`.`estado` AS `pl_estado`,`ing`.`id` AS `ingreso_id`,`ing`.`fecha_ingreso` AS `fecha_ingreso`,`ing`.`llegada_at` AS `llegada_at`,`ing`.`descarga_inicio_at` AS `descarga_inicio_at`,`ing`.`descarga_fin_at` AS `descarga_fin_at`,`ing`.`operarios_cant` AS `operarios_cant`,`t`.`exp_uv_total` AS `exp_uv_total`,`t`.`exp_uc_total` AS `exp_uc_total`,`t`.`rcv_uv_total` AS `rcv_uv_total`,`t`.`rcv_uc_total` AS `rcv_uc_total`,`t`.`diff_uv_total` AS `diff_uv_total`,`t`.`diff_uc_total` AS `diff_uc_total`,coalesce(`p`.`pallets_rcv`,0) AS `pallets_rcv`,timestampdiff(MINUTE,`ing`.`llegada_at`,`ing`.`descarga_inicio_at`) AS `min_cola_llegada_a_inicio`,timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) AS `min_descarga_efectiva`,timestampdiff(MINUTE,`ing`.`llegada_at`,`ing`.`descarga_fin_at`) AS `min_total_llegada_a_fin`,(case when ((`ing`.`descarga_inicio_at` is not null) and (`ing`.`descarga_fin_at` is not null) and (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) > 0)) then round((`t`.`rcv_uv_total` / (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) / 60)),2) else NULL end) AS `uv_por_hora`,(case when ((`ing`.`descarga_inicio_at` is not null) and (`ing`.`descarga_fin_at` is not null) and (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) > 0)) then round((`t`.`rcv_uc_total` / (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) / 60)),2) else NULL end) AS `uc_por_hora`,(case when ((`ing`.`operarios_cant` is not null) and (`ing`.`operarios_cant` > 0) and (`ing`.`descarga_inicio_at` is not null) and (`ing`.`descarga_fin_at` is not null) and (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) > 0)) then round((`t`.`rcv_uv_total` / (`ing`.`operarios_cant` * (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) / 60))),2) else NULL end) AS `uv_por_operario_hora`,(case when ((`ing`.`operarios_cant` is not null) and (`ing`.`operarios_cant` > 0) and (`ing`.`descarga_inicio_at` is not null) and (`ing`.`descarga_fin_at` is not null) and (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) > 0)) then round((`t`.`rcv_uc_total` / (`ing`.`operarios_cant` * (timestampdiff(MINUTE,`ing`.`descarga_inicio_at`,`ing`.`descarga_fin_at`) / 60))),2) else NULL end) AS `uc_por_operario_hora` from (((`pl_packinglist` `pl` left join `pl_last_ingreso` `ing` on(((`ing`.`packinglist_id` = `pl`.`id`) and (`ing`.`rn` = 1)))) left join `pl_totales` `t` on((`t`.`packinglist_id` = `pl`.`id`))) left join `pl_pallets` `p` on((`p`.`packinglist_id` = `pl`.`id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_pl_item_resumen`
--

/*!50001 DROP VIEW IF EXISTS `v_pl_item_resumen`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_pl_item_resumen` AS select `i`.`id` AS `pl_item_id`,`i`.`packinglist_id` AS `packinglist_id`,`pl`.`codigo` AS `packinglist_codigo`,`i`.`sku_cliente` AS `sku_cliente`,`i`.`producto_id` AS `producto_id`,`i`.`descripcion` AS `descripcion`,`i`.`lote_codigo` AS `lote_codigo`,`i`.`expected_uv` AS `expected_uv`,`i`.`expected_uc` AS `expected_uc`,`i`.`received_uv` AS `received_uv`,`i`.`received_uc` AS `received_uc`,`i`.`diff_uv` AS `diff_uv`,`i`.`diff_uc` AS `diff_uc`,`i`.`checked_item` AS `checked_item`,sum(coalesce(`l`.`uv_cajas`,0)) AS `rcv_agg_uv`,sum(coalesce(`l`.`uc_unidades`,0)) AS `rcv_agg_uc` from ((`pl_packinglist_item` `i` join `pl_packinglist` `pl` on((`pl`.`id` = `i`.`packinglist_id`))) left join `pl_rcv_link` `l` on((`l`.`pl_item_id` = `i`.`id`))) group by `i`.`id`,`i`.`packinglist_id`,`pl`.`codigo`,`i`.`sku_cliente`,`i`.`producto_id`,`i`.`descripcion`,`i`.`lote_codigo`,`i`.`expected_uv`,`i`.`expected_uc`,`i`.`received_uv`,`i`.`received_uc`,`i`.`diff_uv`,`i`.`diff_uc`,`i`.`checked_item` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_pl_resumen`
--

/*!50001 DROP VIEW IF EXISTS `v_pl_resumen`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_pl_resumen` AS select `pl`.`id` AS `packinglist_id`,`pl`.`codigo` AS `packinglist_codigo`,`pl`.`cliente_ref` AS `cliente_ref`,`pl`.`fecha` AS `fecha`,`pl`.`estado` AS `estado`,`pl`.`checked_all` AS `checked_all`,count(`i`.`id`) AS `items_total`,sum(`i`.`expected_uv`) AS `exp_uv_total`,sum(`i`.`expected_uc`) AS `exp_uc_total`,sum(`i`.`received_uv`) AS `rcv_uv_total`,sum(`i`.`received_uc`) AS `rcv_uc_total`,sum((`i`.`expected_uv` - `i`.`received_uv`)) AS `diff_uv_total`,sum((`i`.`expected_uc` - `i`.`received_uc`)) AS `diff_uc_total`,sum((case when (`i`.`checked_item` = 1) then 1 else 0 end)) AS `items_checked` from (`pl_packinglist` `pl` left join `pl_packinglist_item` `i` on((`i`.`packinglist_id` = `pl`.`id`))) group by `pl`.`id`,`pl`.`codigo`,`pl`.`cliente_ref`,`pl`.`fecha`,`pl`.`estado`,`pl`.`checked_all` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_so_devoluciones`
--

/*!50001 DROP VIEW IF EXISTS `v_so_devoluciones`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_so_devoluciones` AS select `r`.`embarque_id` AS `embarque_id`,`e`.`codigo` AS `embarque`,`r`.`llegada_at` AS `retorno_llegada`,`d`.`id` AS `devolucion_id`,`dest`.`razon_social` AS `destinatario`,`d`.`doc_tipo` AS `doc_tipo`,`d`.`doc_numero` AS `doc_numero`,`m`.`code` AS `motivo`,`pr`.`denominacion` AS `producto`,`l`.`codigo` AS `lote`,`d`.`qty_pallets` AS `qty_pallets`,`d`.`qty_uv` AS `qty_uv`,`d`.`qty_uc` AS `qty_uc`,`d`.`created_at` AS `created_at` from ((((((`so_devolucion` `d` join `so_retorno` `r` on((`r`.`id` = `d`.`retorno_id`))) join `so_embarque` `e` on((`e`.`id` = `r`.`embarque_id`))) left join `para_destinatarios` `dest` on((`dest`.`id` = `d`.`destinatario_id`))) join `para_devolucion_motivo` `m` on((`m`.`id` = `d`.`motivo_id`))) join `para_productos` `pr` on((`pr`.`id` = `d`.`producto_id`))) left join `wh_lote` `l` on((`l`.`id` = `d`.`lote_id`))) order by `d`.`created_at` desc */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_so_embarque_kpi`
--

/*!50001 DROP VIEW IF EXISTS `v_so_embarque_kpi`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_so_embarque_kpi` AS select `e`.`id` AS `embarque_id`,`e`.`codigo` AS `embarque_codigo`,`depp`.`code` AS `deposito_code`,`e`.`creado_at` AS `creado_at`,`e`.`llegada_at` AS `llegada_at`,`e`.`carga_inicio_at` AS `carga_inicio_at`,`e`.`carga_fin_at` AS `carga_fin_at`,`e`.`salida_at` AS `salida_at`,`e`.`ayudantes_cant` AS `ayudantes_cant`,`ee`.`code` AS `estado`,`e`.`km_inicial` AS `km_inicial`,`e`.`temp_salida_c` AS `temp_salida_c`,timestampdiff(MINUTE,`e`.`llegada_at`,`e`.`carga_inicio_at`) AS `min_espera_carga`,timestampdiff(MINUTE,`e`.`carga_inicio_at`,`e`.`carga_fin_at`) AS `min_carga_efectiva`,timestampdiff(MINUTE,`e`.`llegada_at`,`e`.`salida_at`) AS `min_total_en_planta`,(select count(0) from `so_embarque_pre` `ep` where (`ep`.`embarque_id` = `e`.`id`)) AS `preembarques`,(select count(0) from `so_embarque_parada` `pa` where (`pa`.`embarque_id` = `e`.`id`)) AS `paradas`,(select count(0) from (`so_parada_doc` `pd` join `so_embarque_parada` `pa` on((`pa`.`id` = `pd`.`parada_id`))) where (`pa`.`embarque_id` = `e`.`id`)) AS `documentos` from ((`so_embarque` `e` join `so_embarque_estado` `ee` on((`ee`.`id` = `e`.`estado_id`))) join `wh_deposito` `depp` on((`depp`.`id` = `e`.`deposito_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_so_pedido_resumen`
--

/*!50001 DROP VIEW IF EXISTS `v_so_pedido_resumen`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_so_pedido_resumen` AS select `p`.`id` AS `pedido_id`,`p`.`codigo` AS `pedido_codigo`,`p`.`fecha_pedido` AS `fecha_pedido`,`pe`.`code` AS `pedido_estado`,`d`.`id` AS `pedido_dest_id`,`dest`.`razon_social` AS `destinatario`,`d`.`doc_tipo` AS `doc_tipo`,`d`.`doc_numero` AS `doc_numero`,sum(`i`.`expected_uv`) AS `expected_uv`,sum(`i`.`expected_uc`) AS `expected_uc`,sum(`i`.`prepared_uv`) AS `prepared_uv`,sum(`i`.`prepared_uc`) AS `prepared_uc`,sum(`i`.`shipped_uv`) AS `shipped_uv`,sum(`i`.`shipped_uc`) AS `shipped_uc`,sum((`i`.`expected_uv` - `i`.`shipped_uv`)) AS `pending_uv`,sum((`i`.`expected_uc` - `i`.`shipped_uc`)) AS `pending_uc` from ((((`so_pedido` `p` join `so_pedido_estado` `pe` on((`pe`.`id` = `p`.`estado_id`))) join `so_pedido_dest` `d` on((`d`.`pedido_id` = `p`.`id`))) join `para_destinatarios` `dest` on((`dest`.`id` = `d`.`destinatario_id`))) join `so_pedido_dest_item` `i` on((`i`.`pedido_dest_id` = `d`.`id`))) group by `p`.`id`,`d`.`id` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_so_ruteo_paradas`
--

/*!50001 DROP VIEW IF EXISTS `v_so_ruteo_paradas`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_so_ruteo_paradas` AS select `e`.`codigo` AS `embarque`,`p`.`orden` AS `orden`,`dest`.`razon_social` AS `destinatario`,`p`.`km_llegada` AS `km_llegada`,`p`.`hora_llegada` AS `hora_llegada`,`p`.`hora_inicio_descarga` AS `hora_inicio_descarga`,`p`.`hora_fin_descarga` AS `hora_fin_descarga`,`p`.`hora_fin_inspeccion` AS `hora_fin_inspeccion`,`p`.`hora_salida` AS `hora_salida`,`p`.`temp_descarga_c` AS `temp_descarga_c`,timestampdiff(MINUTE,`p`.`hora_llegada`,`p`.`hora_inicio_descarga`) AS `min_espera`,timestampdiff(MINUTE,`p`.`hora_inicio_descarga`,`p`.`hora_fin_descarga`) AS `min_descarga`,timestampdiff(MINUTE,`p`.`hora_llegada`,`p`.`hora_salida`) AS `min_entrega` from ((`so_embarque_parada` `p` join `so_embarque` `e` on((`e`.`id` = `p`.`embarque_id`))) join `para_destinatarios` `dest` on((`dest`.`id` = `p`.`destinatario_id`))) order by `e`.`id`,`p`.`orden` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_wh_moves_min`
--

/*!50001 DROP VIEW IF EXISTS `v_wh_moves_min`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_wh_moves_min` AS select `m`.`id` AS `id`,`m`.`tipo` AS `tipo`,`m`.`motivo` AS `motivo`,`m`.`deposito_id` AS `deposito_id`,`d`.`code` AS `deposito_code`,`m`.`pallet_id` AS `pallet_id`,`m`.`producto_id` AS `producto_id`,`m`.`lote_id` AS `lote_id`,`m`.`from_pos_id` AS `from_pos_id`,`m`.`to_pos_id` AS `to_pos_id`,`m`.`delta_uv` AS `delta_uv`,`m`.`delta_uc` AS `delta_uc`,`m`.`created_at` AS `created_at` from (`wh_move` `m` join `wh_deposito` `d` on((`d`.`id` = `m`.`deposito_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_wh_pallets_cuarentena`
--

/*!50001 DROP VIEW IF EXISTS `v_wh_pallets_cuarentena`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_wh_pallets_cuarentena` AS select `p`.`codigo` AS `pallet`,`pe`.`code` AS `estado`,`d`.`code` AS `deposito_code`,`p`.`posicion_id` AS `posicion_id`,`pos`.`code_full` AS `posicion` from (((`wh_pallet` `p` join `wh_pallet_estado` `pe` on((`pe`.`id` = `p`.`estado_id`))) join `wh_deposito` `d` on((`d`.`id` = `p`.`deposito_id`))) left join `wh_posicion` `pos` on((`pos`.`id` = `p`.`posicion_id`))) where (`pe`.`code` = 'CUARENTENA') */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_wh_posiciones`
--

/*!50001 DROP VIEW IF EXISTS `v_wh_posiciones`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_wh_posiciones` AS select `p`.`id` AS `id`,`p`.`deposito_id` AS `deposito_id`,`d`.`code` AS `deposito_code`,`p`.`rack` AS `rack`,`p`.`columna` AS `columna`,`p`.`nivel` AS `nivel`,`p`.`fondo` AS `fondo`,`p`.`lado` AS `lado`,`p`.`code_full` AS `code_full`,`p`.`ambiente_id` AS `ambiente_id`,`a`.`code` AS `ambiente_code`,`a`.`nombre` AS `ambiente_nombre` from ((`wh_posicion` `p` join `wh_deposito` `d` on((`d`.`id` = `p`.`deposito_id`))) join `wh_ambiente` `a` on((`a`.`id` = `p`.`ambiente_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_wh_posiciones_dep1`
--

/*!50001 DROP VIEW IF EXISTS `v_wh_posiciones_dep1`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_wh_posiciones_dep1` AS select `v_wh_posiciones`.`id` AS `id`,`v_wh_posiciones`.`deposito_id` AS `deposito_id`,`v_wh_posiciones`.`rack` AS `rack`,`v_wh_posiciones`.`columna` AS `columna`,`v_wh_posiciones`.`nivel` AS `nivel`,`v_wh_posiciones`.`fondo` AS `fondo`,`v_wh_posiciones`.`lado` AS `lado`,`v_wh_posiciones`.`code_full` AS `code_full`,`v_wh_posiciones`.`ambiente_id` AS `ambiente_id` from `v_wh_posiciones` where (`v_wh_posiciones`.`deposito_code` = 'DEP1') */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_wh_stock`
--

/*!50001 DROP VIEW IF EXISTS `v_wh_stock`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_wh_stock` AS select `s`.`id` AS `id`,`s`.`deposito_id` AS `deposito_id`,`d`.`code` AS `deposito_code`,`s`.`posicion_id` AS `posicion_id`,`s`.`producto_id` AS `producto_id`,`s`.`lote_id` AS `lote_id`,`s`.`pallet_id` AS `pallet_id`,`s`.`qty_uv` AS `qty_uv`,`s`.`qty_uc` AS `qty_uc`,`s`.`pickeado` AS `pickeado`,`s`.`updated_at` AS `updated_at` from (`wh_stock` `s` join `wh_deposito` `d` on((`d`.`id` = `s`.`deposito_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `v_wh_stock_dep1`
--

/*!50001 DROP VIEW IF EXISTS `v_wh_stock_dep1`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_0900_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `v_wh_stock_dep1` AS select `v_wh_stock`.`deposito_id` AS `deposito_id`,`v_wh_stock`.`posicion_id` AS `posicion_id`,`v_wh_stock`.`producto_id` AS `producto_id`,`v_wh_stock`.`lote_id` AS `lote_id`,`v_wh_stock`.`pallet_id` AS `pallet_id`,`v_wh_stock`.`qty_uv` AS `qty_uv`,`v_wh_stock`.`qty_uc` AS `qty_uc`,`v_wh_stock`.`pickeado` AS `pickeado`,`v_wh_stock`.`updated_at` AS `updated_at` from `v_wh_stock` where (`v_wh_stock`.`deposito_code` = 'DEP1') */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-27 10:48:27
