<?php

// ensure DataTables.php was included
// this file must not be included when installed using composer
if (!defined('DATATABLES')) {
	exit(1);
}

// Enable error reporting for debugging (remove for production)
error_reporting(\E_ALL);
ini_set('display_errors', '1');

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Database user / pass
 */
// Prefer using the app's PDO directly to ensure parity with .env and avoid duplicating credentials
$__ROOT = dirname(__DIR__, 3);
if (is_file($__ROOT . '/config/db.php')) {
	require_once $__ROOT . '/config/db.php';
}

$appPdo = null;
if (function_exists('getPDO')) {
	try {
		$appPdo = getPDO();
	} catch (\Throwable $e) {
		// fallback to env-based details below
	}
}

if ($appPdo instanceof \PDO) {
	$sql_details = [
		'type' => 'Mysql', // type is ignored when 'pdo' is supplied
		'pdo'  => $appPdo,
	];
} else {
	// Fallback: env-based details (minimal) if PDO couldn't be obtained
	if (is_file($__ROOT . '/config/config.php')) {
		require_once $__ROOT . '/config/config.php';
	}
	if (!function_exists('env')) {
		function env($key, $default = null) {
			$val = getenv($key);
			return $val !== false ? $val : $default;
		}
	}
	$driver = strtolower((string) env('DB_CONNECTION', 'mysql'));
	$typeMap = [
		'mysql'   => 'Mysql',
		'mariadb' => 'Mysql',
		'pgsql'   => 'Postgres',
		'postgres'=> 'Postgres',
		'postgresql'=> 'Postgres',
		'sqlsrv'  => 'Sqlserver',
		'sqlite'  => 'Sqlite',
		'oci'     => 'Oracle',
		'oci8'    => 'Oracle',
		'oracle'  => 'Oracle',
	];
	$type = $typeMap[$driver] ?? 'Mysql';
	$sql_details = [
		'type'   => $type,
		'user'   => (string) env('DB_USERNAME', 'root'),
		'pass'   => (string) env('DB_PASSWORD', ''),
		'host'   => (string) env('DB_HOST', 'localhost'),
		'port'   => (string) env('DB_PORT', ''),
		'db'     => (string) env('DB_DATABASE', 'sol'),
		'dsn'    => $type === 'Mysql' ? 'charset=utf8mb4' : '',
		'pdoAttr'=> [],
	];
}

// This is included for the development and deploy environment used on the DataTables
// server. You can delete this block - it just includes my own user/pass without making
// them public!
if (is_file($_SERVER['DOCUMENT_ROOT'] . '/datatables/pdo.php')) {
	include $_SERVER['DOCUMENT_ROOT'] . '/datatables/pdo.php';
}
// /End development include
