<?php

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: Login (simple)
 * - Usa assets desde /public/assets
 * - Usa variables .env vía constantes (PROYECTO_TITULO, PROYECTO_CLIENTE, PROYECTO_LEMA)
 * - Acción del form a /backend/auth_login.php (lo implementamos luego)
 */
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <meta name="description" content="Login · <?= htmlspecialchars(PROYECTO_TITULO) ?>">
    <meta name="author" content="arasaIT">

    <link rel="icon" href="<?= url('/assets/img/favicon.png') ?>" type="image/png">
    <link rel="shortcut icon" href="<?= url('/assets/img/favicon.png') ?>" type="image/png">

    <title><?= htmlspecialchars(PROYECTO_TITULO) ?></title>

    <!-- Google Fonts (opcionales) -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&family=Roboto:wght@300;400;500;700&family=Rubik:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />

    <!-- Icon fonts (si los copiaste a /assets/css) -->
    <link rel="stylesheet" href="<?= url('/assets/css/fontawesome.css') ?>">
    <link rel="stylesheet" href="<?= url('/assets/css/icofont.css') ?>">
    <link rel="stylesheet" href="<?= url('/assets/css/themify.css') ?>">
    <link rel="stylesheet" href="<?= url('/assets/css/flag-icon.css') ?>">
    <link rel="stylesheet" href="<?= url('/assets/css/feather-icon.css') ?>">

    <!-- Bootstrap & theme -->
    <link rel="stylesheet" href="<?= url('/assets/css/bootstrap.css') ?>">
    <link rel="stylesheet" href="<?= url('/assets/css/style.css') ?>">
    <link id="color" rel="stylesheet" href="<?= url('/assets/css/color-7.css') ?>" media="screen">
    <link rel="stylesheet" href="<?= url('/assets/css/responsive.css') ?>">

    <!-- Tu CSS compilado (si lo usas) -->
    <!-- <link rel="stylesheet" href="<?= url('/assets/css/app.css') ?>"> -->

    <style>
    /* Position the show/hide button inside the password input and
       add right padding to the input so both fields keep the same width */
    .position-relative { position: relative; }
    .position-relative .show-hide {
        position: absolute;
        top: 50%;
        right: 12px;
        transform: translateY(-50%);
        color: #6c757d;
        background: transparent;
        border: 0;
        z-index: 2;
        line-height: 1;
        padding: 0.25rem;
    }
    .position-relative .show-hide i { font-size: 1.1rem; }
    .position-relative .show-hide:hover { color: #343a40; }
    .position-relative .show-hide:focus { outline: none; box-shadow: none; }

    /* Ensure password input leaves space for the button so its visual width
       matches the username input */
    .position-relative .form-control { padding-right: 3rem; }
    </style>

</head>

<body>
    <!-- Loader (opcional, si tu theme lo usa) -->
    <div class="loader-wrapper" style="display:none">
        <div class="theme-loader">
            <div class="loader-p"></div>
        </div>
    </div>

    <section>
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-12">
                    <div class="login-card shadow-sm border-0 rounded-3 p-4">
                        <form class="theme-form login-form" action="<?= url('/login') ?>" method="POST" autocomplete="off" novalidate>
                            <div class="mb-4 text-center">
                                <img src="<?= url(PROYECTO_LOGO_CLIENTE) ?>"
                                    alt="Logo" style="max-height:160px"
                                    onerror="this.style.display='none'">
                                <!-- <h4 class="mt-3 mb-1"><?= htmlspecialchars(PROYECTO_TITULO) ?></h4> -->
                                <h6 class="text-muted small"><?= htmlspecialchars(PROYECTO_LEMA) ?></h6>
                            </div>

                            <div class="form-group mb-3">
                                <label for="usuario" class="form-label">Usuario</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-user"></i></span>
                                    <input class="form-control" type="text" id="usuario" name="usuario" required placeholder="Usuario" autofocus>
                                </div>
                            </div>

                            <div class="form-group mb-4">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="icon-lock"></i></span>
                                    <div class="position-relative">
                                        <input
                                            type="password"
                                            id="password"
                                            name="password"
                                            class="form-control"
                                            autocomplete="current-password" />                                        
                                        <button
                                            type="button"
                                            class="show-hide btn p-0"
                                            aria-label="Mostrar contraseña"
                                            aria-pressed="false"
                                            data-target="#password">
                                            <i class="fa-regular fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group d-grid">
                                <button class="btn btn-primary btn-lg" type="submit">Ingresar</button>
                            </div>

                            <?php if (!empty($_GET['e'])): ?>
                                <div class="alert alert-danger mt-3 mb-0 py-2">
                                    <?= htmlspecialchars($_GET['e']) ?>
                                </div>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Core JS (orden habitual del theme) -->
    <script src="<?= url('/assets/js/jquery-3.5.1.min.js') ?>"></script>
    <script src="<?= url('/assets/js/icons/feather-icon/feather.min.js') ?>"></script>
    <script src="<?= url('/assets/js/icons/feather-icon/feather-icon.js') ?>"></script>
    <script src="<?= url('/assets/js/config.js') ?>"></script>
    <script src="<?= url('/assets/js/bootstrap/popper.min.js') ?>"></script>
    <script src="<?= url('/assets/js/bootstrap/bootstrap.min.js') ?>"></script>
    <script src="<?= url('/assets/js/script.js') ?>"></script>

    <!-- Tu JS compilado (si lo usas) -->
    <script src="<?= url('/assets/js/app.js') ?>"></script>
</body>

</html>