<?php
declare(strict_types=1);
/**
 * Sección de cabecera para el dashboard de Control.
 */

if (!function_exists('e')) {
    function e(string $s): string
    {
        return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
    }
}

$projectTitle = $_ENV['PROYECTO_TITULO'] ?? $_ENV['APP_NAME'] ?? 'SOL';
?>
<div class="row align-items-center mb-3">
  <div class="col">
    <h1 class="h3 mb-0"><?= e($projectTitle) ?></h1>
    <small class="text-muted">Panel de Control • Dashboard</small>
  </div>
  <div class="col-auto">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item"><a href="<?= e(url('/control/dashboard')) ?>">Control</a></li>
        <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
      </ol>
    </nav>
  </div>
</div>
