<?php
declare(strict_types=1);
/**
 * Sección: Tarjetas de métricas (datos reales).
 */

if (!function_exists('project_path')) {
  function project_path(string $rel): string
  {
    return rtrim(dirname(__DIR__, 4), DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . ltrim($rel, DIRECTORY_SEPARATOR);
  }
}

require_once project_path('config/db.php');

$pdo = null;
try {
    $pdo = getPDO();
} catch (Throwable $e) {
    error_log('[dashboard.stats_general] DB init error: ' . $e->getMessage());
}

$metric = function (?PDO $pdo, string $sql, array $params = []): int {
    if (!$pdo) {
        return 0;
    }
    try {
        $st = $pdo->prepare($sql);
        $st->execute($params);
        $val = (int)($st->fetchColumn() ?? 0);
        return $val < 0 ? 0 : $val;
    } catch (Throwable $e) {
        error_log('[dashboard.stats_general] metric error: ' . $e->getMessage());
        return 0;
    }
};

$palletsEnDeposito = 0;
if ($pdo instanceof PDO) {
    try {
        $hasTbl = static function (PDO $pdo, string $table): bool {
            $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ?");
            $st->execute([$table]);
            return (int)$st->fetchColumn() > 0;
        };
        $hasCol = static function (PDO $pdo, string $table, string $column): bool {
            $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ?");
            $st->execute([$table, $column]);
            return (int)$st->fetchColumn() > 0;
        };

        $palTbl = $hasTbl($pdo, 'wh_pallet') ? 'wh_pallet' : ($hasTbl($pdo, 'wh_pallets') ? 'wh_pallets' : null);
        $posCol = null;
        if ($palTbl) {
            if ($hasCol($pdo, $palTbl, 'posicion_id')) {
                $posCol = 'posicion_id';
            } elseif ($hasCol($pdo, $palTbl, 'pos_id')) {
                $posCol = 'pos_id';
            }
        }

        if ($palTbl && $posCol) {
            $embId = 0;
            $cuaId = 0;
            try {
                $embId = (int)($pdo->query("SELECT id FROM wh_pallet_estado WHERE code='EMBARCADO' LIMIT 1")->fetchColumn() ?: 0);
            } catch (Throwable $e) {
            }
            try {
                $cuaId = (int)($pdo->query("SELECT id FROM wh_pallet_estado WHERE code='CUARENTENA' LIMIT 1")->fetchColumn() ?: 0);
            } catch (Throwable $e) {
            }

            $sql = "SELECT COUNT(*)
                      FROM {$palTbl} p
                      JOIN wh_posicion pos ON pos.id = p.{$posCol}
                     WHERE p.{$posCol} IS NOT NULL
                       AND (pos.activo = 1 OR pos.activo IS NULL)";
            if ($embId && $palTbl === 'wh_pallet') {
                $sql .= " AND (p.estado_id IS NULL OR p.estado_id <> {$embId})";
            }
            if ($cuaId && $palTbl === 'wh_pallet') {
                $sql .= " AND (p.estado_id IS NULL OR p.estado_id <> {$cuaId})";
            }
            $palletsEnDeposito = $metric($pdo, $sql);
        } else {
            $palletsEnDeposito = $metric($pdo, 'SELECT COUNT(*) FROM wh_pallet WHERE posicion_id IS NOT NULL');
        }
    } catch (Throwable $e) {
        $palletsEnDeposito = $metric($pdo, 'SELECT COUNT(*) FROM wh_pallet WHERE deleted_at IS NULL AND posicion_id IS NOT NULL');
    }
}

$productosTotal = $metric($pdo, 'SELECT COUNT(*) FROM para_productos');
$pedidosTotal   = $metric($pdo, 'SELECT COUNT(*) FROM so_pedido');
$movimientosHoy = $metric(
    $pdo,
    'SELECT COUNT(*) FROM wh_move WHERE DATE(created_at) = CURDATE()'
);
?>
<div class="row">
  <div class="col-sm-6 col-xl-3 col-lg-6">
    <div class="card o-hidden border-0">
      <div class="bg-primary b-r-4 card-body">
        <div class="media static-top-widget">
          <div class="align-self-center text-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-box">
              <path d="M21 16V8a2 2 0 0 0-1-1.73L13 2.27a2 2 0 0 0-2 0L4 6.27A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
              <polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline>
              <line x1="12" y1="22.08" x2="12" y2="12"></line>
            </svg>
          </div>
          <div class="media-body"><span class="m-0">Pallets ubicados (en posición)</span>
            <h4 class="mb-0 counter"><?= number_format($palletsEnDeposito); ?></h4>
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-box icon-bg">
              <path d="M21 16V8a2 2 0 0 0-1-1.73L13 2.27a2 2 0 0 0-2 0L4 6.27A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
              <polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline>
              <line x1="12" y1="22.08" x2="12" y2="12"></line>
            </svg>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3 col-lg-6">
    <div class="card o-hidden border-0">
      <div class="bg-secondary b-r-4 card-body text-dark">
        <div class="media static-top-widget">
          <div class="align-self-center text-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-bag">
              <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
              <line x1="3" y1="6" x2="21" y2="6"></line>
              <path d="M16 10a4 4 0 0 1-8 0"></path>
            </svg>
          </div>
          <div class="media-body"><span class="m-0">Productos</span>
            <h4 class="mb-0 counter"><?= number_format($productosTotal); ?></h4>
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-bag icon-bg">
              <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
              <line x1="3" y1="6" x2="21" y2="6"></line>
              <path d="M16 10a4 4 0 0 1-8 0"></path>
            </svg>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3 col-lg-6">
    <div class="card o-hidden border-0">
      <div class="bg-primary b-r-4 card-body">
        <div class="media static-top-widget">
          <div class="align-self-center text-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-circle">
              <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path>
            </svg>
          </div>
          <div class="media-body"><span class="m-0">Pedidos</span>
            <h4 class="mb-0 counter"><?= number_format($pedidosTotal); ?></h4>
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-circle icon-bg">
              <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path>
            </svg>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-xl-3 col-lg-6">
    <div class="card o-hidden border-0">
      <div class="bg-secondary b-r-4 card-body text-dark">
        <div class="media static-top-widget">
          <div class="align-self-center text-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-move">
              <polyline points="5 9 2 12 5 15"></polyline>
              <polyline points="9 5 12 2 15 5"></polyline>
              <polyline points="15 19 12 22 9 19"></polyline>
              <polyline points="19 9 22 12 19 15"></polyline>
              <line x1="2" y1="12" x2="22" y2="12"></line>
              <line x1="12" y1="2" x2="12" y2="22"></line>
            </svg>
          </div>
          <div class="media-body"><span class="m-0">Movimientos hoy</span>
            <h4 class="mb-0 counter"><?= number_format($movimientosHoy); ?></h4>
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-move icon-bg">
              <polyline points="5 9 2 12 5 15"></polyline>
              <polyline points="9 5 12 2 15 5"></polyline>
              <polyline points="15 19 12 22 9 19"></polyline>
              <polyline points="19 9 22 12 19 15"></polyline>
              <line x1="2" y1="12" x2="22" y2="12"></line>
              <line x1="12" y1="2" x2="12" y2="22"></line>
            </svg>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
