<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/control/dashboard/index.php
 * Punto de entrada del panel principal dentro del módulo Control.
 */

$BASE = dirname(__DIR__, 3);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Dashboard');
sol_section('breadcrumb', [
	['label' => 'Dashboard', 'url' => null],
]);

ob_start();

include project_path('views/control/dashboard/_partials/hero.php');
include project_path('views/control/dashboard/_partials/stats_general.php');
include project_path('views/control/dashboard/_partials/stats_pallets.php');
include project_path('views/control/dashboard/_partials/ultimos-movimientos.php');
include project_path('views/control/dashboard/_partials/charts.php');

$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
