<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/control/inventario/editar/index.php
 * Formulario: Crear/Editar conteo de inventario
 */

$BASE = dirname(__DIR__, 4);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// Determinar si es nuevo o editar
$conteoId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$isEdit = $conteoId > 0;

// -------------------------
// Meta
// -------------------------
sol_section('page_title', $isEdit ? 'Control · Editar Conteo' : 'Control · Nuevo Conteo');

// -------------------------
// Assets
// -------------------------
sol_assets_push(
  [],
  [
    url('page-scripts/pages/control/inventario_nuevo.js')
  ]
);

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>

<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <!-- Botón volver -->
      <div class="mb-3">
        <a href="<?= url('/control/inventario') ?>" class="btn btn-outline-secondary">
          <i class="fa fa-arrow-left me-1"></i> Volver a listado
        </a>
      </div>

      <!-- Card con formulario principal -->
      <div class="card mb-3">
        <div class="card-header">
          <h5 class="mb-0"><?= $isEdit ? 'Editar Conteo' : 'Nuevo Conteo' ?></h5>
        </div>
        <div class="card-body">
          <form id="frmConteo">
            <input type="hidden" id="conteo_id" name="id" value="<?= $conteoId ?>">
            
            <div class="row g-3">
              <!-- Código (solo lectura si existe) -->
              <div class="col-md-3">
                <label for="codigo" class="form-label">Código *</label>
                <input type="text" class="form-control" id="codigo" name="codigo" 
                       placeholder="CNT-AAAAMMDD-###" <?= $isEdit ? 'readonly' : '' ?> required>
                <small class="text-muted">Se genera automáticamente</small>
              </div>

              <!-- Fecha de conteo -->
              <div class="col-md-3">
                <label for="fecha_conteo" class="form-label">Fecha de Conteo *</label>
                <input type="date" class="form-control" id="fecha_conteo" name="fecha_conteo" 
                       value="<?= date('Y-m-d') ?>" required>
              </div>

              <!-- Depósito -->
              <div class="col-md-3">
                <label for="deposito_id" class="form-label">Depósito *</label>
                <select class="form-select" id="deposito_id" name="deposito_id" required>
                  <option value="">Seleccione...</option>
                </select>
              </div>

              <!-- Cliente (opcional) -->
              <div class="col-md-3">
                <label for="cliente_id" class="form-label">Cliente</label>
                <select class="form-select" id="cliente_id" name="cliente_id">
                  <option value="">Todos los clientes</option>
                </select>
                <small class="text-muted">Dejar en "Todos" para conteo general</small>
              </div>

              <!-- Tipo -->
              <div class="col-md-3">
                <label for="tipo" class="form-label">Tipo *</label>
                <select class="form-select" id="tipo" name="tipo" required>
                  <option value="GENERAL">General</option>
                  <option value="CICLICO">Cíclico</option>
                  <option value="PARCIAL">Parcial</option>
                </select>
              </div>

              <!-- Estado -->
              <div class="col-md-3">
                <label for="estado" class="form-label">Estado *</label>
                <select class="form-select" id="estado" name="estado" required>
                  <option value="BORRADOR" selected>Borrador</option>
                  <option value="EN_PROCESO">En Proceso</option>
                  <option value="FINALIZADO">Finalizado</option>
                </select>
              </div>

              <!-- Observaciones -->
              <div class="col-md-6">
                <label for="observaciones" class="form-label">Observaciones</label>
                <textarea class="form-control" id="observaciones" name="observaciones" 
                          rows="2" placeholder="Notas generales del conteo..."></textarea>
              </div>

              <!-- Botones -->
              <div class="col-12 d-flex justify-content-end gap-2">
                <button type="button" id="btnCancelar" class="btn btn-secondary">
                  Cancelar
                </button>
                <button type="submit" class="btn btn-primary">
                  <i class="fa fa-save me-1"></i> Guardar Cabecera
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>

      <!-- Sección de Items (solo si ya se guardó la cabecera) -->
      <div id="seccionItems" style="<?= $isEdit ? '' : 'display:none;' ?>">
        <div class="card">
          <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Items Contados</h5>
            <button type="button" id="btnAgregarItem" class="btn btn-success btn-sm">
              <i class="fa fa-plus me-1"></i> Agregar SKU
            </button>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-sm table-hover align-middle" id="tblItems">
                <thead class="table-light">
                  <tr>
                    <th>SKU</th>
                    <th>Producto</th>
                    <th>Lote</th>
                    <th>Posición</th>
                    <th class="text-end">Pallets</th>
                    <th class="text-end">Cajas (UV)</th>
                    <th class="text-end">Unidades (UC)</th>
                    <th class="text-end">Total Unidades</th>
                    <th>Observaciones</th>
                    <th width="100">Acciones</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td colspan="10" class="text-center text-muted">
                      No hay items. Haga clic en "Agregar SKU" para comenzar.
                    </td>
                  </tr>
                </tbody>
                <tfoot class="table-secondary fw-bold">
                  <tr>
                    <td colspan="4" class="text-end">TOTALES:</td>
                    <td class="text-end" id="total_pallets">0</td>
                    <td class="text-end" id="total_cajas">0</td>
                    <td class="text-end" id="total_unidades">0</td>
                    <td class="text-end" id="total_total_unidades">0</td>
                    <td colspan="2"></td>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

<!-- Modal: Agregar/Editar Item -->
<div class="modal fade" id="mdlItem" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="mdlItemTitle">Agregar Item</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <form id="frmItem">
          <input type="hidden" id="item_id" name="item_id">
          <input type="hidden" id="item_conteo_id" name="conteo_id">

          <div class="row g-3">
            <!-- Producto (SKU) -->
            <div class="col-md-6">
              <label for="item_producto_id" class="form-label">Producto (SKU) *</label>
              <select class="form-select" id="item_producto_id" name="producto_id" required>
                <option value="">Seleccione...</option>
              </select>
            </div>

            <!-- Lote -->
            <div class="col-md-3">
              <label for="item_lote" class="form-label">Lote</label>
              <input type="text" class="form-control" id="item_lote" name="lote" 
                     placeholder="Ej: L20250105">
              <small class="text-muted">Conteo a ciegas</small>
            </div>

            <!-- Posición -->
            <div class="col-md-3">
              <label for="item_posicion" class="form-label">Posición</label>
              <input type="text" class="form-control" id="item_posicion" name="posicion" 
                     placeholder="Ej: A-01-03">
              <small class="text-muted">Conteo a ciegas</small>
            </div>

            <!-- Cantidad de Pallets -->
            <div class="col-md-3">
              <label for="item_cantidad_pallets" class="form-label">Pallets</label>
              <input type="number" class="form-control" id="item_cantidad_pallets" 
                     name="cantidad_pallets" value="0" min="0" step="1">
            </div>

            <!-- Cantidad de Cajas (UV) -->
            <div class="col-md-3">
              <label for="item_cantidad_cajas" class="form-label">Cajas (UV)</label>
              <input type="number" class="form-control" id="item_cantidad_cajas" 
                     name="cantidad_cajas" value="0" min="0" step="1">
            </div>

            <!-- Cantidad de Unidades (UC) -->
            <div class="col-md-3">
              <label for="item_cantidad_unidades" class="form-label">Unidades (UC)</label>
              <input type="number" class="form-control" id="item_cantidad_unidades" 
                     name="cantidad_unidades" value="0" min="0" step="1">
            </div>

            <!-- Total Unidades (calculado) -->
            <div class="col-md-3">
              <label for="item_total_unidades_display" class="form-label">Total UC</label>
              <input type="text" class="form-control text-end fw-bold" 
                     id="item_total_unidades_display" readonly
                     style="background-color: #e9ecef; color: #000;">
              <input type="hidden" id="item_total_unidades" name="total_unidades">
              <small class="text-muted">Auto-calculado</small>
            </div>

            <!-- Info del producto (UC por caja, cajas por pallet) -->
            <div class="col-12">
              <div class="alert alert-info" id="infoProducto" style="display:none;">
                <strong>Producto:</strong> <span id="info_producto_nombre"></span><br>
                <strong>UC por Caja:</strong> <span id="info_uc_por_caja">-</span> | 
                <strong>Cajas por Pallet:</strong> <span id="info_cajas_por_pallet">-</span>
              </div>
            </div>

            <!-- Observaciones -->
            <div class="col-12">
              <label for="item_observaciones" class="form-label">Observaciones</label>
              <textarea class="form-control" id="item_observaciones" name="observaciones" 
                        rows="2" placeholder="Notas sobre este item..."></textarea>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" id="btnGuardarItem" class="btn btn-primary">
          <i class="fa fa-save me-1"></i> Guardar Item
        </button>
      </div>
    </div>
  </div>
</div>

<?php
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
