<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/control/inventario/index.php
 * Módulo: Conteo de Inventario (CRUD)
 */

$BASE = dirname(__DIR__, 3);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Control · Inventario / Conteos');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/control/inventario_conteos.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'conteosTable';
$tableDescription = 'Listado de conteos de inventario realizados';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>

<div class="row mb-3">
  <div class="col-md-10 d-flex align-items-end gap-2 flex-wrap">
    <div>
      <label for="filtroEstado" class="form-label">Estado</label>
      <select id="filtroEstado" class="form-select">
        <option value="">Todos</option>
        <option value="BORRADOR">Borrador</option>
        <option value="EN_PROCESO">En Proceso</option>
        <option value="FINALIZADO">Finalizado</option>
        <option value="APROBADO">Aprobado</option>
        <option value="RECHAZADO">Rechazado</option>
      </select>
    </div>
    <div>
      <label for="filtroTipo" class="form-label">Tipo</label>
      <select id="filtroTipo" class="form-select">
        <option value="">Todos</option>
        <option value="GENERAL">General</option>
        <option value="CICLICO">Cíclico</option>
        <option value="PARCIAL">Parcial</option>
      </select>
    </div>
    <div>
      <label class="form-label">&nbsp;</label>
      <button type="button" id="btnAplicarFiltro" class="btn btn-primary d-block">
        <i class="fa fa-search me-1"></i> Aplicar
      </button>
    </div>
  </div>
  <div class="col-md-2 d-flex align-items-end justify-content-end">
    <button type="button" id="btnNuevoConteo" class="btn btn-success">
      <i class="fa fa-plus me-1"></i> Nuevo Conteo
    </button>
  </div>
  <div class="col-12"><hr/></div>
</div>

<?php
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
