<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/deposito/cuarentena/index.php
 * Página para listar pallets en cuarentena por Ingreso y acceder a la asignación de posiciones.
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Depósito · Pallets en Cuarentena');
// Carga DataTables + el script de la página
sol_dt_assets('/page-scripts/pages/deposito/cuarentena.js');

ob_start();
?>

<div class="d-flex align-items-center gap-2 mb-3">
  <h4 class="m-0 flex-grow-1">Pallets en Cuarentena</h4>
  <a id="btnIrAsignacion" class="btn btn-primary btn-sm disabled" href="#" tabindex="-1" aria-disabled="true">
    <i class="bi bi-box-arrow-in-right me-1"></i> Asignar posiciones…
  </a>
  <button id="btnRefrescar" class="btn btn-outline-secondary btn-sm">
    <i class="bi bi-arrow-clockwise"></i> Refrescar
  </button>
  <button id="btnLimpiar" class="btn btn-outline-secondary btn-sm">
    Limpiar
  </button>
  
  
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmCuar" class="row g-2 align-items-end">
      <div class="col-12 col-md-3">
        <label for="fIngresoId" class="form-label">Ingreso ID</label>
        <input type="number" min="1" class="form-control" id="fIngresoId" name="ingreso_id" placeholder="Ej.: 123">
      </div>
      <div class="col-12 col-md-3">
        <button type="submit" class="btn btn-primary w-100">Buscar</button>
      </div>
      <div class="col-12 col-md-6">
        <small class="text-muted">Ingresá el número de Ingreso y presioná “Buscar” para listar los pallets en cuarentena vinculados a ese Ingreso.</small>
      </div>
    </form>
  </div>
  
</div>

<!-- Resultados -->
<div class="card">
  <div class="card-body">
    <div id="msgInfo" class="alert alert-info mb-3">Indicá un Ingreso para consultar.</div>
    <div class="table-responsive">
      <table id="palletsCuarentenaTable" class="table table-sm table-striped align-middle w-100">
        <thead>
          <tr>
            <th>ID</th>
            <th>Código Pallet</th>
            <th>Producto</th>
            <th>Lote</th>
            <th>Vencimiento</th>
            <th>Posición actual</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
  </div>
</div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
