<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/deposito/inmovilizados/index.php
 * Reporte: Productos inmovilizados (sin OUTBOUND en X días)
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Depósito · Productos inmovilizados');
sol_dt_assets('/page-scripts/pages/deposito/inmovilizados.js');

$tableId          = 'inmovilizadosTable';
$tableDescription = 'Productos sin salidas en los últimos N días, con stock actual y última SALIDA.';

ob_start();
?>

<!-- Toolbar -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a id="btnPdfInmov" class="btn btn-primary btn-sm disabled" tabindex="-1" aria-disabled="true"
     href="#" title="Próximamente">
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmInmov" class="row g-2">
      <div class="col-12 col-md-2">
        <label class="form-label">Sin ventas (días)</label>
        <input type="number" min="1" class="form-control" id="fDias" name="dias" value="90">
      </div>
      <div class="col-12 col-md-2">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>
      <div class="col-12 col-md-2">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>
      <div class="col-12 col-md-4">
        <label class="form-label">Producto (SKU o denominación)</label>
        <input type="text" class="form-control" id="fQ" name="q" placeholder="Buscar…">
      </div>
      <div class="col-12 col-md-2">
        <label class="form-label">Incluir sin stock</label>
        <select class="form-select" id="fSinStock" name="incluir_sin_stock">
          <option value="no" selected>No</option>
          <option value="si">Sí</option>
        </select>
      </div>

      <div class="col-12 col-md-3 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>
    </form>
  </div>
</div>

<?php
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
