<?php
declare(strict_types=1);

/**
 * Vista: views/operaciones/deposito/layout/index.php
 * Interfaz para visualizar/generar el layout del depósito (posiciones)
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Operaciones · Depósito · Layout');
// Load the script that handles deposito/ambiente selects and layout fetching
sol_dt_assets('/page-scripts/pages/deposito/layout.js');

ob_start();
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="m-0">Layout del depósito</h4>
  <div>
    <button id="btnExportLayoutJson" class="btn btn-outline-secondary btn-sm">Exportar JSON</button>
    <button id="btnRefreshLayout" class="btn btn-primary btn-sm">Refrescar</button>
  </div>
</div>

<div class="card mb-3">
  <div class="card-body">
    <form id="frmLayoutFilters" class="row g-2">
      <div class="col-md-4">
        <label class="form-label">Depósito</label>
        <select id="fDeposito" name="deposito_id" class="form-select"></select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Ambiente (opcional)</label>
        <select id="fAmbiente" name="ambiente_id" class="form-select"><option value="">(Todos)</option></select>
      </div>
      <div class="col-md-4 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar</button>
      </div>
    </form>
  </div>
</div>

<div id="layoutCanvas" class="card">
  <div class="card-body">
    <div id="layoutMsg" class="alert alert-info">Pulsa "Refrescar" para cargar el layout.</div>
    <div id="layoutGrid" style="min-height:200px"></div>
  </div>
</div>

<!-- Modal: Detalle de posición / pallets -->
<div class="modal fade" id="mdlPosicion" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detalle de posición</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="mdlPosicionBody">
          <div class="text-muted">Cargando...</div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
  </div>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
