<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/deposito/rotacion/index.php
 * Reporte: Sugerencias de reorden por alta rotación
 *
 * - Muestra los productos con mayor rotación (OUT).
 * - Se agrupan por grupo o clase de producto.
 * - Sugiere reubicación prioritaria (zona frontal / alta accesibilidad).
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

sol_section('page_title', 'Depósito · Reorden');
sol_dt_assets('/page-scripts/pages/deposito/rotacion.js');

$tableId          = 'reordenTable';
$tableDescription = 'Reubicaciones de productos en el depósito.';

ob_start();
?>

<!-- Card de movimiento de depósito con doble layout visual (microtiles) -->
<div class="card mb-4">
  <div class="card-header pb-0 card-no-border">
    <h3 class="mb-3">Movimiento de Depósito: Selección de Origen y Destino</h3>
  </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-6">
        <h5>Desde (Origen)</h5>
        <form id="formOrigen" class="mb-2">
          <div class="row g-2">
            <div class="col">
              <label class="form-label">Depósito</label>
              <select name="deposito_id" id="deposito_id_origen" required></select>
            </div>
            <div class="col">
              <label class="form-label">Ambiente</label>
              <select name="ambiente_id" id="ambiente_id_origen"></select>
            </div>
            <div class="col">
              <label class="form-label">Rack</label>
              <select name="rack_id" id="rack_id_origen" required></select>
            </div>
            <div class="col-auto d-flex align-items-end">
              <button type="submit" class="btn btn-primary">Ver layout</button>
            </div>
          </div>
        </form>
        <div id="layoutDesde"></div>
      </div>
      <div class="col-md-6">
        <h5>Hasta (Destino)</h5>
        <form id="formDestino" class="mb-2">
          <div class="row g-2">
            <div class="col">
              <label class="form-label">Depósito</label>
              <select name="deposito_id" id="deposito_id_destino" required></select>
            </div>
            <div class="col">
              <label class="form-label">Ambiente</label>
              <select name="ambiente_id" id="ambiente_id_destino"></select>
            </div>
            <div class="col">
              <label class="form-label">Rack</label>
              <select name="rack_id" id="rack_id_destino" required></select>
            </div>
            <div class="col-auto d-flex align-items-end">
              <button type="submit" class="btn btn-primary">Ver layout</button>
            </div>
          </div>
        </form>
        <div id="layoutHasta"></div>
      </div>
    </div>
    <div class="mt-3">
      <button id="btnConfirmarMovimiento" class="btn btn-primary" disabled>Confirmar Movimiento</button>
      <button id="btnCancelarMovimiento" class="btn btn-secondary">Cancelar</button>
    </div>
  </div>
</div>
<div class="modal fade" id="modalPallets" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Seleccionar pallets en posición</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="palletsContainer"></div>
      <div class="modal-footer">
        <button id="btnPalletSelect" class="btn btn-primary" disabled>Seleccionar</button>
      </div>
    </div>
  </div>
</div>



<?php $pageJs[] = url('/page-scripts/pages/deposito/layout.js');
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
