<?php
declare(strict_types=1);
/**
 * Encabezado principal para la vista de Inicio (home).
 *
 * Muestra saludo breve y contexto sin exponer métricas.
 */

if (!function_exists('e')) {
  function e(string $value): string
  {
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
  }
}

$projectTitle = (string) ($_ENV['PROYECTO_TITULO'] ?? $_ENV['APP_NAME'] ?? 'SOL');
$usuarioNombre = trim((string) ($_SESSION['usuario_nombre'] ?? ''));
$greeting = $usuarioNombre !== '' ? "Hola, {$usuarioNombre}" : $projectTitle;
?>
<div class="d-flex align-items-center gap-2 mb-0">
  <h5 class="m-0"><?= e($greeting) ?></h5>
  <span class="text-muted">Centro de accesos rápidos del sistema.</span>
</div>