<?php
declare(strict_types=1);
/**
 * Accesos directos con aspecto de widget Viho.
 *
 * Referencia visual: /themes/viho/HTML/template/general-widget.html
 */

if (!function_exists('e')) {
  function e(string $value): string
  {
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
  }
}

$sections = [
  [
    'title' => 'Ingresos',
    'subtitle' => 'Entradas y recepción de mercadería',
    'icon' => 'bi-box-arrow-in-down',
    'accent' => 'primary',
    'text_color' => 'text-white',
    'link_accent' => 'primary',
    'links' => [
      ['label' => 'Packing list', 'url' => '/ingresos/packing'],
      ['label' => 'Recepción', 'url' => '/ingresos/recepcion'],
      ['label' => 'Ingresos registrados', 'url' => '/ingresos/listado'],
    ],
  ],
  [
    'title' => 'Depósito',
    'subtitle' => 'Estado del inventario en piso',
    'icon' => 'bi-building',
    'accent' => 'secondary',
    'text_color' => 'text-dark',
    'link_accent' => 'secondary',
    'links' => [
      ['label' => 'Layout del depósito', 'url' => '/deposito/layout'],
      ['label' => 'Pallets en cuarentena', 'url' => '/deposito/cuarentena'],
      ['label' => 'Rotación', 'url' => '/deposito/rotacion'],
    ],
  ],
  [
    'title' => 'Salidas',
    'subtitle' => 'Preparación de pedidos y embarque',
    'icon' => 'bi-truck',
    'accent' => 'primary',
    'text_color' => 'text-white',
    'link_accent' => 'primary',
    'links' => [
      ['label' => 'Packing list de pedidos', 'url' => '/salidas/packing'],
      ['label' => 'Pedidos activos', 'url' => '/salidas/listado'],
      ['label' => 'Embarque', 'url' => '/salidas/embarque'],
    ],
  ],
  [
    'title' => 'Operaciones',
    'subtitle' => 'Gestión de móviles y operaciones',
    'icon' => 'bi bi-activity',
    'accent' => 'secondary',
    'text_color' => 'text-dark',
    'link_accent' => 'secondary',
    'links' => [
      ['label' => 'Disponibilidad de móviles', 'url' => '/operaciones/moviles_disponibles'],
      ['label' => 'Dashboard', 'url' => '/control/dashboard'],
    ],
  ],
  [
    'title' => 'Control',
    'subtitle' => 'Panel de control y gestión general',
    'icon' => 'bi bi-check2-circle',
    'accent' => 'primary',
    'text_color' => 'text-light',
    'link_accent' => 'primary',
    'links' => [
      ['label' => 'Mapeo de posiciones', 'url' => '/control/mapeo'],
      ['label' => 'Inventario', 'url' => '/control/inventario'],
    ],
  ],  
];

?>
<div class="container-fluid py-1">
  <div class="row g-3 g-xl-4 mt-2">
    <?php include project_path('views/control/dashboard/_partials/stats_general.php');  ?>
    <?php foreach ($sections as $section):
      $accent = $section['accent'];
      $textClass = $section['text_color'];
      $mutedClass = $textClass === 'text-dark' ? 'text-muted' : 'text-light';
      $linkAccent = $section['link_accent'];
      ?>
      <div class="col-12 col-md-6 col-xl-4">
        <div class="card quick-link-card border-0 shadow-sm h-100">
          <div class="card-header border-0 bg-<?= e($accent) ?> <?= e($textClass) ?> py-4">
            <div class="d-flex align-items-start gap-3">
              <span
                class="d-inline-flex align-items-center justify-content-center rounded-circle border border-light shadow-sm"
                style="width:3rem;height:3rem;background-color:rgba(255,255,255,0.15);">
                <i class="bi <?= e($section['icon']) ?> fs-4 <?= e($textClass) ?>"></i>
              </span>
              <div class="flex-grow-1">
                <h5 class="mb-1 fw-semibold <?= e($textClass) ?>"><?= e($section['title']) ?></h5>
                <small class="<?= e($mutedClass) ?> d-block"><?= e($section['subtitle']) ?></small>
              </div>
            </div>
          </div>
          <div class="card-body p-0">
            <div class="list-group list-group-flush">
              <?php foreach ($section['links'] as $link): ?>
                <a class="list-group-item list-group-item-action py-3 d-flex align-items-center justify-content-between"
                  href="<?= e(url($link['url'])) ?>">
                  <span class="d-flex align-items-center gap-2">
                    <i class="bi bi-arrow-right-short fs-4 text-<?= e($linkAccent) ?>"></i>
                    <span class="fw-semibold"><?= e($link['label']) ?></span>
                  </span>
                  <i class="bi bi-chevron-right text-muted"></i>
                </a>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>