<?php

declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';
require_once $BASE . '/config/db.php';

$ingresoId = (int)($_GET['ingreso_id'] ?? 0);
if ($ingresoId <= 0) {
    http_response_code(400);
    echo "Falta ingreso_id";
    exit;
}

$defaultDepositoId = null;
try {
    $pdo = get_pdo();
    $stmt = $pdo->prepare('SELECT deposito_id FROM pl_ingreso WHERE id = ? LIMIT 1');
    $stmt->execute([$ingresoId]);
    $value = $stmt->fetchColumn();
    if ($value !== false) {
        $defaultDepositoId = (int)$value ?: null;
    }
} catch (Throwable $e) {
    $defaultDepositoId = null;
}

sol_section('page_title', "Asignar Posiciones - Ingreso #{$ingresoId}");
sol_dt_assets('/page-scripts/pages/ingresos/asignar_posiciones_scripts.js');

ob_start();
?>
<div class="container-fluid py-3" id="asignarPosiciones" data-ingreso-id="<?= $ingresoId ?>" data-deposito-id="<?= $defaultDepositoId ?? '' ?>">
    <div class="d-flex align-items-center gap-2 mb-3">
        <a class="btn btn-outline-secondary btn-sm" href="<?= url('/ingresos/detalle?ingreso_id=' . $ingresoId) ?>">← Volver al detalle</a>
        <h5 class="m-0 flex-grow-1">Asignar Posiciones - Ingreso #<?= $ingresoId ?></h5>
        <button class="btn btn-warning btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#autoCargaCard" aria-expanded="false" aria-controls="autoCargaCard">
            <i class="bi bi-lightning"></i> AutoCarga
        </button>
    </div>

    <!-- AutoCarga (oculto por defecto) -->
    <div id="autoCargaCard" class="card collapse mb-3">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <h6 class="mb-0">AutoCarga a PICKING</h6>
                <small class="text-muted">Planifica y aplica automáticamente carga desde Cuarentena a posiciones PICKING</small>
            </div>
        </div>
        <div class="card-body">
            <form id="frmAutoPicking" class="row g-3 align-items-end" onsubmit="return false;">
                <div class="col-auto">
                    <label for="autoCap" class="form-label mb-0 small">Capacidad/posición</label>
                    <input type="number" id="autoCap" class="form-control form-control-sm" value="20" min="1" step="1" style="width: 140px;" />
                </div>
                <div class="col-auto">
                    <label for="autoLimit" class="form-label mb-0 small">Límite (opcional)</label>
                    <input type="number" id="autoLimit" class="form-control form-control-sm" value="" min="0" step="1" placeholder="0 = sin límite" style="width: 160px;" />
                </div>
                <div class="col-auto">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="1" id="autoSim" />
                        <label class="form-check-label small" for="autoSim">Simulación</label>
                    </div>
                </div>
                <div class="col-auto">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="1" id="autoIncludePos" />
                        <label class="form-check-label small" for="autoIncludePos">Incluir con posición</label>
                    </div>
                </div>
                <div class="col-auto d-flex align-items-center">
                    <div class="form-check me-2">
                        <input class="form-check-input" type="checkbox" value="1" id="autoChangeState" checked />
                        <label class="form-check-label small" for="autoChangeState">Cambiar estado</label>
                    </div>
                    <input type="text" id="autoTargetState" class="form-control form-control-sm" placeholder="POS_PICKEADO" style="width: 140px;" />
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-success btn-sm" id="btnAutoPicking">
                        <i class="bi bi-lightning"></i> Carga automática a picking
                    </button>
                </div>
                <div class="col-auto">
                    <span id="autoPickingBadge" class="badge bg-secondary-subtle text-secondary-emphasis" style="display:none;"></span>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <!-- Panel izquierdo: Pallets en cuarentena -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Pallets en Cuarentena</h6>
                    <small class="text-muted">Selecciona pallets para asignar</small>
                </div>
                <div class="card-body">
                    <div id="palletsList" class="d-grid gap-2">
                        <!-- Pallets se cargarán aquí -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Panel derecho: Layout del depósito -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-0">Layout del Depósito</h6>
                        <small class="text-muted">Haz clic en una posición disponible para seleccionarla</small>
                    </div>
                    <div class="d-flex gap-2 align-items-end">
                        <button type="button" class="btn btn-primary btn-sm" id="btnRefreshLayout">
                            <i class="bi bi-arrow-clockwise"></i> Refrescar
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filtros de depósito usando el sistema existente -->
                    <form id="frmLayoutFilters" class="row g-2 mb-3">
                        <div class="col-md-4">
                            <label class="form-label">Depósito</label>
                            <select id="fDeposito" name="deposito_id" class="form-select"></select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Ambiente (opcional)</label>
                            <select id="fAmbiente" name="ambiente_id" class="form-select">
                                <option value="">(Todos)</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Rack (opcional)</label>
                            <select id="fRack" name="rack" class="form-select">
                                <option value="">(Todos)</option>
                            </select>
                        </div>
                    </form>

                    <!-- Leyenda -->
                    <div class="mb-3">
                        <small class="d-flex gap-3 text-muted">
                            <span><span class="badge bg-success me-1">&nbsp;</span> Disponible</span>
                            <span><span class="badge bg-warning me-1">&nbsp;</span> Ocupado</span>
                            <span><span class="badge bg-danger me-1">&nbsp;</span> Bloqueado</span>
                            <span><span class="badge bg-primary me-1">&nbsp;</span> Seleccionado</span>
                        </small>
                    </div>

                    <!-- Layout canvas usando el sistema existente -->
                    <div id="layoutCanvas">
                        <div id="layoutMsg" class="alert alert-info">Selecciona un depósito para ver su layout.</div>
                        <div id="layoutGrid" style="min-height: 400px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.pallet-item {
    padding: 8px 12px;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.pallet-item:hover {
    background-color: #e9ecef;
    border-color: #adb5bd;
}

.pallet-item.selected {
    background-color: #d1ecf1;
    border-color: #bee5eb;
    color: #0c5460;
}

.position-cell {
    width: 40px;
    height: 40px;
    margin: 2px;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    font-size: 10px;
    text-align: center;
    transition: all 0.2s ease;
}

.position-cell.available {
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.position-cell.occupied {
    background-color: #fff3cd;
    border-color: #ffeaa7;
}

.position-cell.blocked {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    cursor: not-allowed;
}

.position-cell.selected {
    background-color: #cce7ff;
    border-color: #80c0ff;
    border-width: 2px;
}

.position-cell:hover:not(.blocked) {
    transform: scale(1.1);
    z-index: 10;
    position: relative;
}

.rack-container {
    margin: 10px 0;
}

.rack-header {
    font-weight: bold;
    margin-bottom: 5px;
    color: #495057;
}
</style>

<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');