<?php

declare(strict_types=1);

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

$ingresoId = (int)($_GET['ingreso_id'] ?? 0);
if ($ingresoId <= 0) {
    http_response_code(400);
    echo "Falta ingreso_id";
    exit;
}

sol_section('page_title', "Detalle de ingreso #{$ingresoId}");
sol_dt_assets('/page-scripts/pages/ingresos/detalle_scripts.js');

ob_start();
?>
<div class="container-fluid py-3" id="ingresoDetalle" data-ingreso-id="<?= $ingresoId ?>">
    <div class="d-flex align-items-center gap-2 mb-3">
        <a class="btn btn-outline-secondary btn-sm" href="<?= url('/ingresos/listado') ?>">← Volver</a>
        <h5 class="m-0 flex-grow-1">Ingreso #<?= $ingresoId ?></h5>

        <!-- Botón PDF -->
        <a class="btn btn-primary btn-sm"
            target="_blank"
            href="<?= url('/api/operaciones/ingreso_pdf.php') . '?ingreso_id=' . (int)$ingresoId ?>">
            <i class="bi bi-filetype-pdf me-1"></i> Descargar PDF
        </a>
    </div>


    <!-- Cabecera -->
    <div class="card mb-3">
        <div class="card-body d-flex flex-wrap gap-3">
            <div><strong>Cliente:</strong> <span id="hdr-cliente">-</span></div>
            <div><strong>Móvil:</strong> <span id="hdr-movil">-</span></div>
            <div><strong>Chofer:</strong> <span id="hdr-chofer">-</span></div>
            <div><strong>Responsable:</strong> <span id="hdr-resp">-</span></div>
            <div><strong>Fecha ingreso:</strong> <span id="hdr-fecha">-</span></div>
            <div><strong>Hora inicio:</strong> <span id="hdr-inicio">-</span></div>
            <div><strong>Operarios:</strong> <span id="hdr-ops">-</span></div>
            <div><strong>Observación:</strong> <span id="hdr-obs">-</span></div>
        </div>
    </div>

    <!-- Pallets -->
    <div class="card mb-3">
        <div class="card-body">
            <h6 class="mb-2">Pallets del ingreso</h6>
            <span class="text-muted">Resumen por pallet que se generó a partir del packing list confirmado</span>
            <table id="tblIngresoPallets" class="table table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Código pallet</th>
                        <th>Posición</th>
                        <th>Ítems</th>
                        <th>UV total</th>
                        <th>UC totales</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="3" class="text-end">Totales:</th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

    <!-- Items -->
    <div class="card mb-3">
        <div class="card-body">
            <h6 class="mb-2">Ítems</h6>
            <span class="text-muted">Detalle línea a línea de lo que hay dentro de los pallets de ese ingreso</span>
            <table id="tblIngresoItems" class="table table-striped">
                <thead>
                    <tr>
                        <th>Pallet</th>
                        <th>SKU</th>
                        <th>Producto</th>
                        <th>Lote</th>
                        <th>F.Prod</th>
                        <th>F.Vto</th>
                        <th>UV cajas</th>
                        <th>UC x caja</th>
                        <th>UC sueltas</th>
                        <th>UC totales</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="6" class="text-end">Totales:</th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Movimientos -->
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <div>
                    <h6 class="mb-1">Movimientos de Ingreso</h6>
                    <span class="text-muted">Resumen por pallet que se generó a partir del packing list confirmado, con tiempos y estado del movimiento</span>
                </div>
                <button type="button" class="btn btn-primary btn-sm" id="btnAsignarPosiciones">
                    <i class="bi bi-grid-3x3-gap me-1"></i> Asignar Posiciones
                </button>
            </div>
            <table id="tblIngresoMoves" class="table table-striped w-100"></table>
        </div>
    </div>

</div>
<?php
$content = ob_get_clean();
include project_path('views/layout/layout_app.php');
