<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/ingresos/listado/index.php
 * Muestra DataTables + Editor para "Ingresos"
 */

$BASE = dirname(__DIR__, 3); // listado -> ingresos -> views -> raíz
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Ingresos de mercaderías');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/ingresos/ingresos_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'ingresosTable';
$tableDescription = 'Listado de ingresos de mercaderías';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>

<!-- Acciones de página -->
<div class="d-flex justify-content-end mb-2">
	<a class="btn btn-sm btn-warning" href="<?= url('/deposito/cuarentena') ?>">
		<i class="bi bi-exclamation-triangle me-1"></i> Pallets en Cuarentena
	</a>
  
</div>
<?php
include project_path('views/layout/_partials/table-def.php'); // tabla genérica de tu layout
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
