<div class="container-fluid py-1">
    <!-- Card: Subir archivo -->
    <div class="card mb-3">
        <div class="card-body">
            <form id="frmUploadPL" class="row g-3" method="POST"  enctype="multipart/form-data">
                <input type="hidden" name="prefer_form" value="1">
                <div class="col-md-5">
                    <label class="form-label">Archivo Excel (.xlsx)</label>
                    <input type="file" name="pl_file" accept=".xlsx,.xls" class="form-control" required>
                    <a class="btn btn-link btn-sm py-2"
                        href="<?= BASE_URL ?>/assets/storage/models/sol_ingreso_packing_modelo.xlsx"
                        target="_blank">
                        <i class="bi bi-file-earmark-excel me-1"></i>Bajar Ejemplo
                    </a>

                    <div class="form-text">Columnas esperadas: sku, denominacion, lote, fecha_produccion, fecha_vencimiento, uv_cajas, unidades_por_uv, uc_sueltas, pallet_hint, position_hint.</div>
                </div>

                <div class="col-md-5">
                    <label class="form-label">Cliente (ruc)</label>
                    <select id="cliente_id" name="cliente_id" class="form-select">
                        <option value="">-- Seleccionar --</option>
                        <?php foreach ($clientes as $c): ?>
                            <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['ruc']) . ' - ' . htmlspecialchars($c['razon_social']) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="form-text">Opcional: se asocia al confirmar.</div>
                </div>

                <!-- Móvil y Chofer removidos: ahora se gestionan en Recepción -->

                <div class="col-md-2 d-flex align-items-end">
                    <button class="btn btn-primary w-100" type="submit">
                        <i class="bi bi-cloud-arrow-up me-1"></i>Subir
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Card: Acciones de confirmación -->
    <div class="card mb-3">
        <div class="card-body d-flex flex-wrap gap-2 align-items-center">
            <button id="btnConfirmPL" class="btn btn-success" type="button">
                <i class="bi bi-check2-circle me-1"></i>Confirmar ingreso desde PL
            </button>
            <span class="text-muted">Solo se podrá confirmar si <strong>no</strong> hay filas con error.</span>
        </div>
    </div>
    <!-- Card: Post confirmación -->
    <div id="plSummaryCardsHost" class="row g-3 mt-3"></div>
    <!-- Card: Previsualización -->
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <div>
                    <h6 class="m-0">Previsualización</h6>
                    <small class="text-muted">Se mostrarán las filas importadas del archivo.</small>
                </div>
                <div id="pl-batch-info" class="small text-muted"></div>
            </div>

            <table id="tblPL" class="table table-striped w-100">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>SKU</th>
                        <th>ProdID</th>
                        <th>Denominación</th>
                        <th>Lote</th>
                        <th>F.Prod</th>
                        <th>F.Vto</th>
                        <th>UV Cajas</th>
                        <th>UC x caja</th>
                        <th>UC sueltas</th>
                        <th>Pallet</th>
                        <th>Posición</th>
                        <th>Error</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>