<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/ingresos/packing/index.php
 * Flujo: Subir PL (.xlsx) → Previsualizar → Confirmar → Genera ingreso + pallets + items.
 */

$BASE = dirname(__DIR__, 3); // packing -> ingresos -> views -> raíz
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';
require_once $BASE . '/config/db.php';

$pdo = get_pdo();

// Combos
$clientes = $pdo->query("SELECT id, ruc, razon_social FROM para_clientes WHERE deleted_at IS NULL ORDER BY ruc")->fetchAll(PDO::FETCH_ASSOC);

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Ingresos · Packing List (Excel)');

// -------------------------
// Assets de la página (usa tu helper para DataTables + script local)
// -------------------------
sol_dt_assets('/page-scripts/pages/ingresos/packing_scripts.js');

// Variables para un partial genérico si lo usas (no obligatorio aquí)
$tableId          = 'tblPL';
$tableDescription = 'Previsualización de filas importadas del Packing List (.xlsx)';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
include project_path('views/ingresos/packing/_partials/hero.php');
include project_path('views/ingresos/packing/_partials/forms.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
