<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/ingresos/recepcion/index.php
 * Objetivo (Paso 1):
 *  - Selector de Packing List pendiente
 *  - Resumen de cantidades esperadas
 *  - Tabla base para registrar pallets recibidos
 */

$BASE = dirname(__DIR__, 3);
require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';
require_once $BASE . '/config/db.php';

/** Título de página dentro del layout */
if (!function_exists('sol_section')) {
  function sol_section(string $name, $value): void { $GLOBALS['__sol_sections'][$name] = $value; }
}
sol_section('page_title', 'Recepción de Ingresos');

/** Inyección de assets comunes + script de página (se implementará en el paso siguiente) */
if (function_exists('sol_dt_assets')) {
  sol_dt_assets('/page-scripts/pages/ingresos/recepcion_scripts.js');
}
ob_start();
?>
<div class="container-fluid py-2">

  <!-- Encabezado y ayuda -->
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h4 class="mb-0">Recepción de Packinglist</h4>
      <small class="text-muted">Registra físicamente los pallets declarados en el Packing List.</small>
    </div>
    <div class="d-flex gap-2">
      <button id="btnRecRefresh" type="button" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-clockwise"></i> Refrescar
      </button>
      <button id="btnRecPrint" type="button" class="btn btn-outline-primary btn-sm">
        <i class="bi bi-printer"></i> Imprimir
      </button>
    </div>
  </div>

  <!-- Cabecera: información rápida (cliente / móvil / chofer) -->
  <div class="mb-3">
    <div class="row gy-2">
      <div class="col-12 col-md-4">
        <div><strong>Cliente:</strong> <span id="hdr-cliente">-</span></div>
      </div>
      <div class="col-12 col-md-4">
        <div><strong>Móvil:</strong> <span id="hdr-movil">-</span></div>
      </div>
      <div class="col-12 col-md-4">
        <div><strong>Chofer:</strong> <span id="hdr-chofer">-</span></div>
      </div>
    </div>
  </div>

  <!-- Selector de PL pendiente -->
  <div class="card mb-3">
    <div class="card-body">
      <div class="row g-3 align-items-end">
        <div class="col-12 col-md-6">
          <label for="selPLPendiente" class="form-label">Packing List pendiente</label>
          <select id="selPLPendiente"
                  class="form-select"
                  data-source="<?= htmlspecialchars(url('/api/operaciones/recepcion.php?meta=pl_pendientes'), ENT_QUOTES, 'UTF-8') ?>">
            <option value="">Seleccione un PL...</option>
            <!-- El script de la página poblará opciones: value=pl_id | text=PL-XXXXX (cliente, fecha) -->
          </select>
          <div id="no-pl-msg" class="alert alert-info mt-2 d-none" role="status">
            No hay Packing Lists pendientes para recibir.
          </div>
        </div>
        <div class="col-12 col-md-3">
          <button id="btnCargarPL" class="btn btn-success w-100">
            <i class="bi bi-box-arrow-in-down"></i> Cargar PL
          </button>
        </div>
        <div class="col-12 col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="" id="chkAutoUbicar" checked>
            <label class="form-check-label" for="chkAutoUbicar">
              Auto-ubicar a <strong>CUARENTENA</strong> por defecto
            </label>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Resumen esperado (según PL) -->
  <div class="row g-3 mb-3" id="resumenEsperado" hidden>
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex flex-wrap align-items-center justify-content-between">
          <div>
            <strong>PL:</strong> <span id="sum-pl-codigo">-</span>
            <span class="text-muted ms-2">Cliente: <span id="sum-pl-cliente">-</span></span>
          </div>
          <div class="text-muted d-flex align-items-center gap-2">
            <div>Fecha: <span id="sum-pl-fecha">-</span></div>
            <button id="btnRecalcTotales" type="button" class="btn btn-sm btn-outline-secondary">Recalcular totales</button>
          </div>
        </div>
        <div class="card-body">
          <div class="row g-3 text-center">
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">Pallets esperados</div>
                <div class="fs-5 fw-bold" id="sum-pallets-esp">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">Ítems</div>
                <div class="fs-5 fw-bold" id="sum-items-esp">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">UV esperadas</div>
                <div class="fs-5 fw-bold" id="sum-uv-esp">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">UC esperadas</div>
                <div class="fs-5 fw-bold" id="sum-uc-esp">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">UV recibidas</div>
                <div class="fs-5 fw-bold" id="sum-uv-rec">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">Ítems pendientes</div>
                <div class="fs-5 fw-bold" id="sum-items-pend">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">UC recibidas</div>
                <div class="fs-5 fw-bold" id="sum-uc-rec">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">Cantidad de SKUs</div>
                <div class="fs-5 fw-bold" id="sum-prod-uniq">0</div>
              </div>
            </div>
            <div class="col-6 col-md-2">
              <div class="border rounded p-2">
                <div class="small text-muted">Discrepancias</div>
                <div class="fs-5 fw-bold" id="sum-discrep">0</div>
              </div>
            </div>
          </div>
          <div class="mt-3 small text-muted">
            <span class="me-3">UV = Unidades de Venta</span>
            <span class="me-3">UC = Unidades de Consumo</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Tabla base de recepción de pallets (edición/registro) -->
  <!-- Panel de metadata de recepción -->
  <div class="card mb-3">
    <div class="card-header d-flex align-items-center justify-content-between">
      <div><strong>Metadatos de la recepción</strong></div>
      <div class="d-flex gap-2">
        <button id="btnGuardarCabecera" class="btn btn-sm btn-primary" type="button">
          <i class="bi bi-save"></i> Guardar cabecera
        </button>
      </div>
    </div>
    <div id="panelMeta">
      <div class="card-body">
        <div class="row g-3">
          <div class="col-12 col-md-3">
            <label class="form-label">Fecha ingreso</label>
            <div class="input-group">
              <input id="meta_fecha_ingreso" type="date" class="form-control">
              <button id="btnFechaIngresoHoy" type="button" class="btn btn-secondary">Hoy</button>
            </div>
          </div>
          <div class="col-6 col-md-2">
            <label class="form-label">Hora arribo</label>
            <div class="input-group">
              <input id="meta_hora_arribo" type="time" class="form-control">
              <button data-target="meta_hora_arribo" type="button" class="btn btn-secondary js-set-time-now">Ahora</button>
            </div>
          </div>
          <div class="col-6 col-md-2">
            <label class="form-label">Hora inicio</label>
            <div class="input-group">
              <input id="meta_hora_inicio" type="time" class="form-control">
              <button data-target="meta_hora_inicio" type="button" class="btn btn-secondary js-set-time-now">Ahora</button>
            </div>
          </div>
          <div class="col-6 col-md-2">
            <label class="form-label">Hora fin</label>
            <div class="input-group">
              <input id="meta_hora_fin" type="time" class="form-control">
              <button data-target="meta_hora_fin" type="button" class="btn btn-secondary js-set-time-now">Ahora</button>
            </div>
          </div>
          <div class="col-6 col-md-3">
            <label class="form-label">Operarios (cant)</label>
            <input id="meta_operarios_cant" type="number" min="0" class="form-control">
          </div>

          <div class="col-6 col-md-3">
            <label class="form-label">Tipo documento</label>
            <select id="meta_tipo_documento" class="form-select" data-no-select2="1">
              <option value="">-- Seleccionar --</option>
              <option value="FACTURA">Factura</option>
              <option value="REMITO">Remito</option>
            </select>
          </div>
          <div class="col-6 col-md-3">
            <label class="form-label">Documento</label>
            <input id="meta_documento_entrada" type="text" class="form-control">
          </div>

          <div class="col-6 col-md-3">
            <label class="form-label">Móvil</label>
            <select id="meta_movil_id" class="form-select">
              <option value="">--</option>
            </select>
          </div>

          <div class="col-6 col-md-3">
            <label class="form-label">Chofer</label>
            <select id="meta_chofer_id" class="form-select">
              <option value="">--</option>
            </select>
          </div>

          <div class="col-12 col-md-6">
            <label class="form-label">Observación</label>
            <input id="meta_observacion" type="text" class="form-control">
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Recepción física -->
  <div class="card d-none" id="panelRecepcionFisica" hidden>
    <div class="card-header d-flex align-items-center justify-content-between">
      <div class="d-flex align-items-center gap-2">
        <strong>Recepción física de pallets</strong>
        <span id="badgeHdrSaved"
              class="badge rounded-pill text-bg-secondary ms-1"
              title="Estado de la cabecera de recepción">
          Cabecera: Pendiente
        </span>
      </div>
      <div class="d-flex gap-2">
        <button id="btnAgregarFila" class="btn btn-outline-success btn-sm">
          <i class="bi bi-plus-square"></i> Agregar fila
        </button>
        <button id="btnGuardarRecepcion" class="btn btn-primary btn-sm">
          <i class="bi bi-check2-circle"></i> Guardar recepción
        </button>
      </div>
    </div>
    <div class="card-body">
      <table id="tblRecepcionPallets" class="table table-striped table-bordered w-100">
        <thead>
          <tr>
            <th>Pallet</th>
            <th>Producto</th>
            <th>Lote</th>
            <th>F. Prod.</th>
            <th>F. Venc.</th>
            <th>UV</th>
            <th>UC</th>
            <th>Peso (kg)</th>
            <th>Ubicación</th>
            <th>Estado</th>
            <th>Acciones</th>
          </tr>
        </thead>
        <tbody>
          <!-- El script poblará filas y/o permitirá agregar manualmente -->
        </tbody>
        <tfoot>
          <tr>
            <th colspan="5" class="text-end">Totales:</th>
            <th id="tot-uv" data-total="0">0</th>
            <th id="tot-uc" data-total="0">0</th>
            <th id="tot-peso" data-total="0">0</th>
            <th colspan="3"></th>
          </tr>
        </tfoot>
      </table>
      <div class="small text-muted">
        * La ubicación se sugiere automáticamente a <strong>CUARENTENA</strong> si está activado “Auto-ubicar”.
      </div>
    </div>
  </div>

  <!-- Panel de progreso y discrepancias -->
  <div class="card mt-3" id="panelProgreso" hidden>
    <div class="card-body">
      <div class="d-flex justify-content-end">
        <button id="btnImprimirRecepcion" type="button" class="btn btn-outline-primary btn-sm d-none" hidden>
          <i class="bi bi-printer"></i> Imprimir recepción
        </button>
      </div>
      <div class="row g-3">
        <div class="col-12 col-md-6">
          <div class="progress" role="progressbar" aria-label="Progreso recepción" aria-valuemin="0" aria-valuemax="100">
            <div id="barProgreso" class="progress-bar" style="width: 0%">0%</div>
          </div>
          <div class="mt-2 small text-muted">
            Recibido: <span id="prog-recibido">0</span> / <span id="prog-esperado">0</span> pallets
          </div>
        </div>
        <div class="col-12 col-md-6">
          <div class="alert alert-warning py-2 mb-0" id="boxDiscrepancias" hidden>
            <strong>Discrepancias detectadas: </strong><span id="litDiscrepancias">0</span>.
            <span class="ms-2">Revise diferencias de UV/UC, lotes o fechas respecto al PL.</span>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
<?php
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
?>