<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/inventario/a_caducar/index.php
 * Reporte: Productos próximos a caducar
 */

$BASE = dirname(__DIR__, 3); // a_caducar -> inventario -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Informes de Inventario · Próximos a caducar');

// -------------------------
// DataTables + script de la página
// -------------------------
// (el JS lo crearemos en el próximo paso)
sol_dt_assets('/page-scripts/pages/inventario/a_caducar_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'aCaducarTable';
$tableDescription = 'Lotes próximos a caducar según umbral configurado';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>

<!-- Toolbar del reporte -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a
    id="btnPdfACaducar"
    class="btn btn-primary btn-sm"
    target="_blank"
    href="<?= url('/api/inventario/a_caducar_pdf.php') ?>"
  >
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>
</div>

<!-- Filtros del reporte -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmFiltrosACaducar" class="row g-2">
      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Producto</label>
        <input type="text" class="form-control" id="fProducto" name="q_producto" placeholder="SKU o denominación...">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Lote</label>
        <input type="text" class="form-control" id="fLote" name="lote" placeholder="Ej: ABC123">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Vence dentro de (días)</label>
        <input type="number" min="0" class="form-control" id="fDentroDias" name="dentro_dias" value="30">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Vencimiento entre (desde)</label>
        <input type="date" class="form-control" id="fVencDesde" name="venc_desde">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Vencimiento entre (hasta)</label>
        <input type="date" class="form-control" id="fVencHasta" name="venc_hasta">
      </div>
      <div class="col-12 col-md-3">
        <label class="form-label">Ubicación</label>
        <input type="text" class="form-control" id="fUbicacion" name="q_ubicacion" placeholder="Ej: R1-C02-N3-F1">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Mostrar</label>
        <select class="form-select" id="fMostrar" name="mostrar">
          <option value="solo_proximos" selected>Solo próximos (<= días)</option>
          <option value="vencidos">Vencidos</option>
          <option value="proximos_y_vencidos">Próximos + vencidos</option>
          <option value="todos">Todos</option>
        </select>
      </div>

      <div class="col-12 col-md-3 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>
    </form>
  </div>
</div>

<?php
// Tabla reutilizando el partial (con tfoot para totales en el JS)
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
