<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/inventario/existencias/index.php
 * P1: tabla vacía con DataTables + scripts específicos.
 */

$BASE = dirname(__DIR__, 3);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';
$e = static fn($v) => htmlspecialchars((string) $v, ENT_QUOTES, 'UTF-8');
sol_section('page_title', 'Existencias de inventario');

sol_dt_assets('/page-scripts/pages/inventario/existencias_scripts.js');

$tableId = 'existenciasTable';
$tableDescription = 'Listado de existencias';

ob_start();
?>
<div class="d-flex align-items-center gap-2 mb-3">
    <h5 class="m-0">Inventario</h5>
    <span class="text-muted">Listado de existencias de productos</span>
</div>
<div class="row g-3 mb-3">
    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Productos</small>
                <h4 class="mb-0 fw-semibold" data-metric="productos"></h4>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Pallets</small>
                <h4 class="mb-0 fw-semibold text-info" data-metric="pallets"></h4>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Cajas (UV)</small>
                <h4 class="mb-0 fw-semibold text-primary" data-metric="cajas"></h4>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Unidades sueltas (UC)</small>
                <h4 class="mb-0 fw-semibold text-warning" data-metric="unidades_sueltas"></h4>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-3">
    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Stock total (UC)</small>
                <h4 class="mb-0 fw-semibold" data-metric="stock"></h4>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Reservados</small>
                <h4 class="mb-0 fw-semibold text-danger" data-metric="reservados"></h4>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Disponibles</small>
                <h4 class="mb-0 fw-semibold text-success" data-metric="disponibles"></h4>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body d-flex flex-column justify-content-center">
                <a class="btn btn-sm btn-outline-primary" target="_blank"
                    href="<?= $e(url('/api/inventario/existencias_pdf.php')) ?>">
                    <i class="bi bi-filetype-pdf me-1"></i> PDF detallado
                </a>
            </div>
        </div>
    </div>
</div>
<?php
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
