<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/inventario/fisico_vs_registrado/index.php
 * Reporte: Físico vs. Registrado (diferencias por presencia)
 */

$BASE = dirname(__DIR__, 3); // fisico_vs_registrado -> inventario -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Informes de Inventario · Físico vs. Registrado (diferencias)');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/inventario/fisico_vs_registrado_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'fisicoVsRegistradoTable';
$tableDescription = 'Presencia de diferencias entre lo físico (ocupación vigente) y lo registrado (ítems) por pallet';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>

<!-- Toolbar del reporte -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a
    id="btnPdfFisicoVsRegistrado"
    class="btn btn-primary btn-sm"
    target="_blank"
    href="<?= url('/api/inventario/fisico_vs_registrado_pdf.php') ?>"
  >
    <i class="bi bi-filetype-pdf me-1"></i> Descargar PDF
  </a>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmFiltrosFvR" class="row g-2">
      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Producto (opcional)</label>
        <input type="text" class="form-control" id="fProducto" name="q_producto" placeholder="SKU o denominación (para pallets con ese producto)">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Código de pallet</label>
        <input type="text" class="form-control" id="fPallet" name="q_pallet" placeholder="Ej: PAL-000123">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Ubicación</label>
        <input type="text" class="form-control" id="fUbicacion" name="q_ubicacion" placeholder="Ej: R1-C02-N3-F1">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Tipo de diferencia</label>
        <select class="form-select" id="fTipo" name="tipo">
          <option value="">(Todos)</option>
          <option value="REGISTRADO_SIN_FISICO">Registrado sin físico (sin ocupación)</option>
          <option value="FISICO_SIN_REGISTRO">Físico sin registro (sin ítems)</option>
        </select>
      </div>

      <div class="col-12 col-md-3 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>
    </form>
  </div>
</div>

<?php
// Tabla – usamos el partial común.
// Columnas esperadas (lado JS):
//  - tipo (REGISTRADO_SIN_FISICO | FISICO_SIN_REGISTRO)
//  - cliente, operativa
//  - pallet_codigo, ubicacion
//  - items_count (registrados), unidades (uc_total), productos_distintos
//  - observacion (breve aclaración)
include project_path('views/layout/_partials/table-def.php');

$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
