<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/inventario/min_max/index.php
 * Reporte: Existencias mínimas y máximas por producto
 */

$BASE = dirname(__DIR__, 3); // min_max -> inventario -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Informes de Inventario · Existencias mínimas y máximas');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/inventario/min_max_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'minMaxTable';
$tableDescription = 'Existencias actuales versus mínimos y máximos definidos';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>
<!-- Toolbar del reporte -->
<div class="d-flex flex-wrap gap-2 mb-3">
    <a
        id="btnPdfMinMax"
        class="btn btn-primary btn-sm"
        target="_blank"
        href="<?= url('/api/inventario/min_max_pdf.php') ?>">
        <i class="bi bi-filetype-pdf me-1"></i> Imprimir o Descargar PDF
    </a>
</div>

<!-- Filtros del reporte -->
<div class="card mb-3">
    <div class="card-body">
        <form id="frmFiltrosMinMax" class="row g-2">
            <div class="col-12 col-md-3">
                <label class="form-label">Cliente</label>
                <select class="form-select" id="fCliente" name="cliente_id">
                    <option value="">(Todos)</option>
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Operativa</label>
                <select class="form-select" id="fOperativa" name="operativa_id">
                    <option value="">(Todas)</option>
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Producto</label>
                <input type="text" class="form-control" id="fProducto" name="q_producto" placeholder="SKU o denominación...">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Estado</label>
                <select class="form-select" id="fEstado" name="estado">
                    <option value="">(Todos)</option>
                    <option value="BAJO">Bajo mínimo</option>
                    <option value="OK">En rango</option>
                    <option value="SOBRE">Sobre máximo</option>
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Criterio de stock</label>
                <select class="form-select" id="fCriterio" name="criterio">
                    <option value="disponibles" selected>Disponibles (stock - reservados)</option>
                    <option value="stock">Stock total</option>
                </select>
            </div>

            <div class="col-12 col-md-3 d-flex align-items-end">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="1" id="fSoloConMin" name="solo_con_min">
                    <label class="form-check-label" for="fSoloConMin">
                        Solo productos con mínimo definido
                    </label>
                </div>
            </div>

            <div class="col-12 col-md-3 d-flex align-items-end">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="1" id="fSoloConMax" name="solo_con_max">
                    <label class="form-check-label" for="fSoloConMax">
                        Solo productos con máximo definido
                    </label>
                </div>
            </div>

            <div class="col-12 col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
            </div>
        </form>
        <!-- Resumen de estados -->
        <div id="resumenEstados" class="d-flex flex-wrap gap-2 mt-3 mb-2">
            <span class="badge bg-danger" id="badgeBajo">Bajo mínimo: 0</span>
            <span class="badge bg-success" id="badgeOk">En rango: 0</span>
            <span class="badge bg-warning text-dark" id="badgeSobre">Sobre máximo: 0</span>
        </div>
    </div>
</div>

<?php
// Tabla reutilizando el partial
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
