<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/inventario/movimientos/index.php
 * Reporte de movimientos de inventario con DataTables + filtros por fecha.
 */

$BASE = dirname(__DIR__, 3);

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

$e = static fn($v) => htmlspecialchars((string) $v, ENT_QUOTES, 'UTF-8');

sol_section('page_title', 'Movimientos de inventario');
sol_dt_assets('/page-scripts/pages/inventario/movimientos_scripts.js');

$tableId = 'movimientosTable';
$tableDescription = 'Movimientos de inventario por producto';

ob_start();
?>
<div class="row g-3 mb-3 align-items-end">
    <div class="col-12 col-md-2">
        <label class="form-label text-muted text-uppercase small" for="movimientosFilterDesde">Desde</label>
        <input type="date" class="form-control" id="movimientosFilterDesde" autocomplete="off">
    </div>
    <div class="col-12 col-md-2">
        <label class="form-label text-muted text-uppercase small" for="movimientosFilterHasta">Hasta</label>
        <input type="date" class="form-control" id="movimientosFilterHasta" autocomplete="off">
    </div>
    <div class="col-12 col-md-2">
        <button type="button" class="btn btn-primary w-100" id="movimientosApplyFilters">
            <i class="bi bi-funnel"></i> Aplicar filtros
        </button>
    </div>
    <div class="col-12 col-md-2">
        <button type="button" class="btn btn-outline-secondary" id="movimientosResetFilters">
            <i class="bi bi-eraser"></i> Limpiar filtros
        </button>
    </div>
    <div class="col-12 col-md-3">
        <a class="btn btn-outline-primary  w-100" id="movimientosPdfLink"
            href="<?= $e(url('/api/inventario/movimientos_pdf.php')) ?>" target="_blank">
            <i class="bi bi-filetype-pdf me-1"></i> Descargar PDF
        </a>
    </div>
</div>
</div>

<div class="row g-3 mb-3">
    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Productos</small>
                <h4 class="mb-0 fw-semibold" data-metric="productos"></h4>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Ingresos</small>
                <h4 class="mb-0 fw-semibold text-success" data-metric="ingresos"></h4>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Salidas</small>
                <h4 class="mb-0 fw-semibold text-danger" data-metric="salidas"></h4>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body">
                <small class="text-muted text-uppercase">Saldo final</small>
                <h4 class="mb-0 fw-semibold" data-metric="saldo_final"></h4>
            </div>
        </div>
    </div>
</div>
<?php
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

include project_path('views/layout/layout_app.php');
