<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/inventario/ubicacion/index.php
 * Reporte: Ubicación en almacén (posiciones ocupadas/libres, por rack/columna/nivel/fondo)
 */

$BASE = dirname(__DIR__, 3); // ubicacion -> inventario -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Informes de Inventario · Por ubicación');

// -------------------------
// DataTables + script específico de la página
// -------------------------
// (Crearemos el JS en el siguiente paso)
sol_dt_assets('/page-scripts/pages/inventario/ubicacion_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'ubicacionTable';
$tableDescription = 'Posiciones del almacén con su estado (ocupada/libre) y, si aplica, el pallet y producto principal';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
?>

<!-- Toolbar del reporte -->
<div class="d-flex flex-wrap gap-2 mb-3">
  <a
    id="btnPdfUbicacion"
    class="btn btn-primary btn-sm"
    target="_blank"
    href="<?= url('/api/inventario/ubicacion_pdf.php') ?>"
  >
    <i class="bi bi-filetype-pdf me-1"></i> Imprimir / Descargar PDF
  </a>
</div>

<!-- Filtros -->
<div class="card mb-3">
  <div class="card-body">
    <form id="frmFiltrosUbicacion" class="row g-2">

      <div class="col-12 col-md-3">
        <label class="form-label">Cliente</label>
        <select class="form-select" id="fCliente" name="cliente_id">
          <option value="">(Todos)</option>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Operativa</label>
        <select class="form-select" id="fOperativa" name="operativa_id">
          <option value="">(Todas)</option>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Estado de posición</label>
        <select class="form-select" id="fEstadoPos" name="estado_pos">
          <option value="">(Todas)</option>
          <option value="ocupada">Ocupadas</option>
          <option value="libre">Libres</option>
        </select>
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Ubicación (texto)</label>
        <input type="text" class="form-control" id="fUbicacion" name="q_ubicacion" placeholder="Ej: R1-C02-N3-F1">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Rack</label>
        <input type="text" class="form-control" id="fRack" name="rack" placeholder="R1">
      </div>

      <div class="col-6 col-md-3">
        <label class="form-label">Columna</label>
        <input type="text" class="form-control" id="fCol" name="columna" placeholder="01">
      </div>

      <div class="col-6 col-md-3">
        <label class="form-label">Nivel</label>
        <input type="text" class="form-control" id="fNivel" name="nivel" placeholder="1">
      </div>

      <div class="col-6 col-md-3">
        <label class="form-label">Fondo</label>
        <input type="text" class="form-control" id="fFondo" name="fondo" placeholder="1">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Producto (opcional)</label>
        <input type="text" class="form-control" id="fProducto" name="q_producto" placeholder="SKU o denominación...">
      </div>

      <div class="col-12 col-md-3">
        <label class="form-label">Pallet</label>
        <input type="text" class="form-control" id="fPallet" name="q_pallet" placeholder="Código de pallet">
      </div>

      <div class="col-12 col-md-3 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100">Aplicar filtros</button>
      </div>

    </form>
  </div>
</div>

<?php
// Tabla común (el JS definirá las columnas y el footer de totales si corresponde)
include project_path('views/layout/_partials/table-def.php');

$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
