<?php
/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista/base: Common::_layout
 * Propósito:
 *  - Layout maestro para páginas interiores, inspirado en el template comprado (estructura page-wrapper, header, sidebar, body, footer).
 *  - Inserta los parciales de topbar, sidebar y footbar.
 *  - Define el "slot" de contenido con $this->section('content').
 *  - Mantiene Bootstrap 5 + jQuery por CDN (decisión del proyecto).
 * Notas:
 *  - En este paso solo montamos la estructura general; los parciales se adaptarán al template en pasos siguientes.
 *  - Se respeta APP_BASE_PATH para URLs de assets: si está definido, los assets se sirven desde {APP_BASE_PATH}/assets.
 *  - Las clases del template (page-wrapper, page-body-wrapper, etc.) se incluyen para facilitar el estilado posterior.
 *  - Suposición: por ahora no cargamos los CSS/JS propios del template (style.css, color-1.css, etc.); los agregaremos en pasos próximos.
 */

$title = $this->e($title ?? 'SOL');
$basePath = rtrim((string)($_ENV['APP_BASE_PATH'] ?? getenv('APP_BASE_PATH') ?: ''), '/');
$assetBase = ($basePath === '' ? '' : $basePath) . '/assets';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title><?= $title ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Iconos (Feather) se inicializan al final -->
  <!-- CSS del proyecto -->
  <link rel="stylesheet" href="<?= $assetBase ?>/css/app.css">
  <style>
    /* Puente mínimo para estructura del template (se ampliará cuando integremos los assets del template) */
    .page-wrapper { min-height: 100vh; background: #f6f7fb; }
    .page-main-header { position: sticky; top: 0; z-index: 1030; background: #fff; border-bottom: 1px solid rgba(0,0,0,.05); }
    .page-body-wrapper { display: flex; min-height: calc(100vh - 56px); }
    header.main-nav { width: 260px; background: #fff; border-right: 1px solid rgba(0,0,0,.05); }
    .page-body { flex: 1; padding: 24px; }
    footer.footer { border-top: 1px solid rgba(0,0,0,.06); background: #fff; padding: 12px 16px; }
    @media (max-width: 991.98px) {
      header.main-nav { position: fixed; left: -260px; top: 56px; height: calc(100vh - 56px); overflow-y: auto; transition: left .25s ease; }
      header.main-nav.show { left: 0; }
      .page-body { padding: 16px; }
    }
  </style>
</head>
<body>
  <!-- Loader básico opcional (del template). De momento visual simple. -->
  <div class="loader-wrapper d-none" aria-hidden="true">
    <div class="text-center p-4">Cargando…</div>
  </div>

  <!-- page-wrapper Start (estructura del template) -->
  <div class="page-wrapper" id="pageWrapper">
    <!-- Page Header Start -->
    <div class="page-main-header">
      <?php $this->insert('Common::topbar'); ?>
    </div>
    <!-- Page Header Ends -->

    <!-- Page Body Start -->
    <div class="page-body-wrapper horizontal-menu">
      <!-- Page Sidebar Start -->
      <header class="main-nav">
        <?php $this->insert('Common::sidebar'); ?>
      </header>
      <!-- Page Sidebar Ends -->

      <!-- Content -->
      <div class="page-body">
        <div class="container-fluid">
          <?= $this->section('content') ?>
        </div>
      </div>
      <!-- Content Ends -->

      <!-- Footer Start -->
      <footer class="footer">
        <?php $this->insert('Common::footbar'); ?>
      </footer>
      <!-- Footer Ends -->
    </div>
    <!-- Page Body Ends -->
  </div>
  <!-- page-wrapper Ends -->

  <!-- jQuery (CDN) -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
  <!-- Bootstrap 5 (bundle con Popper) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Feather Icons -->
  <script src="https://cdn.jsdelivr.net/npm/feather-icons@4.29.2/dist/feather.min.js"></script>

  <!-- JS del proyecto -->
  <script src="<?= $assetBase ?>/js/app.js"></script>
  <script>
    // Inicializar feather icons si están presentes
    if (window.feather) { window.feather.replace(); }

    // Toggle simple para sidebar en móviles (placeholder hasta integrar JS del template)
    document.addEventListener('click', function (e) {
      const toggler = e.target.closest('[data-sidebar-toggle]');
      if (toggler) {
        const nav = document.querySelector('header.main-nav');
        if (nav) nav.classList.toggle('show');
      }
    });
  </script>
</body>
</html>
