<?php

declare(strict_types=1);
$e = static fn($s) => htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
$base = rtrim((string) url('/'), '/') . '/';
?>
<!-- jQuery primero -->
<script src="<?= $e(url('/assets/js/jquery-3.5.1.min.js')) ?>"></script>

<!-- Select2 (SOLO una vez) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<!-- Auto-init para .form-select (tu archivo) -->
<script src="<?= $e(url('/assets/js/theme/select2-init.js')) ?>"></script>

<!-- Resto del template -->
<script src="<?= $e(url('/assets/js/icons/feather-icon/feather.min.js')) ?>"></script>
<script src="<?= $e(url('/assets/js/icons/feather-icon/feather-icon.js')) ?>"></script>
<script src="<?= $e(url('/assets/js/sidebar-menu.js')) ?>"></script>
<script src="<?= $e(url('/assets/js/config.js')) ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?= $e(url('/assets/js/bootstrap/popper.min.js')) ?>"></script>
<script src="<?= $e(url('/assets/js/bootstrap/bootstrap.min.js')) ?>"></script>
<script src="https://cdn.datatables.net/2.3.4/js/dataTables.min.js"></script>
<script src="<?= $e(url('/assets/js/script.js')) ?>"></script>
<!-- <script src="<?= $e(url('/assets/js/app.js')) ?>"></script> -->


<?php if (!empty($pageJs) && is_array($pageJs)) foreach ($pageJs as $src): ?>
  <script src="<?= $e($src) ?>"></script>
<?php endforeach; ?>

<?php if (!empty($pageScriptsEnd)) echo $pageScriptsEnd; ?>