<?php
declare(strict_types=1);
$e = static fn($s) => htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
$__pageTitle    = isset($__pageTitle) ? (string)$__pageTitle : (string)($_ENV['PROYECTO_TITULO'] ?? $_ENV['APP_NAME'] ?? 'SOL');
$__pageExtraCss = (isset($__pageExtraCss) && is_array($__pageExtraCss)) ? $__pageExtraCss : [];
?>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="<?= $e($_ENV['APP_LEMA'] ?? 'Sistema de Operaciones Logísticas') ?>">
<meta name="author" content="arasaIT">
<link rel="icon" href="<?= $e(url('/assets/img/favicon.png')) ?>" type="image/png">
<!-- App base URL for frontend scripts -->
<meta name="base-url" content="<?= $e(rtrim(url('/'), '/')) ?>">

<title><?= $e($__pageTitle) ?></title>

<link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800;900&family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
<!-- Template CSS -->
<link rel="stylesheet" href="<?= $e(url('/assets/css/fontawesome.css')) ?>">
<link rel="stylesheet" href="<?= $e(url('/assets/css/icofont.css')) ?>">
<link rel="stylesheet" href="<?= $e(url('/assets/css/themify.css')) ?>">
<link rel="stylesheet" href="<?= $e(url('/assets/css/flag-icon.css')) ?>">
<link rel="stylesheet" href="<?= $e(url('/assets/css/feather-icon.css')) ?>">
<link rel="stylesheet" href="<?= $e(url('/assets/css/sweetalert2.css')) ?>">

<?php foreach ($__pageExtraCss as $__href): ?>
  <link rel="stylesheet" href="<?= $e($__href) ?>">
<?php endforeach; ?>

<!-- Bootstrap -->
<link rel="stylesheet" href="<?= $e(url('/assets/css/bootstrap.css')) ?>">
<!-- <link rel="stylesheet" href="node_modules/bootstrap-icons/font/bootstrap-icons.css"> -->
<!-- Select2 CSS (elige UNO; recomiendo el oficial) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!-- Theme CSS -->
<link rel="stylesheet" href="<?= $e(url('/assets/css/style.css')) ?>">
<link rel="stylesheet" id="color" href="<?= $e(url('/assets/css/color-7.css')) ?>" media="screen">
<link rel="stylesheet" href="<?= $e(url('/assets/css/responsive.css')) ?>">

<!-- Tu CSS -->
<!-- <link rel="stylesheet" href="<?= $e(url('/assets/css/app.css')) ?>"> -->

<!-- Asegurar que el buscador NO esté oculto por estilos del template -->
<style>
  .select2-search--dropdown { display: block !important; }
  /* Ensure warning badges have dark text for readability across the app */
  .badge.bg-warning, .badge.text-bg-warning { color: #212529 !important; }
  /* Global: center card titles (used as table headers across modules) */
  .card .card-title { text-align: center; }
  /* DataTables headers stay legible when dark mode is active */
  :root[data-bs-theme="dark"] table.dataTable thead > tr > th,
  :root[data-bs-theme="dark"] table.dataTable thead > tr > td,
  body.dark table.dataTable thead > tr > th,
  body.dark table.dataTable thead > tr > td,
  body.dark-mode table.dataTable thead > tr > th,
  body.dark-mode table.dataTable thead > tr > td,
  html.dark table.dataTable thead > tr > th,
  html.dark table.dataTable thead > tr > td {
    color: var(--bs-emphasis-color, #f8f9fa) !important;
  }
  :root[data-bs-theme="dark"] table thead th,
  :root[data-bs-theme="dark"] table thead td,
  body[data-bs-theme="dark"] table thead th,
  body[data-bs-theme="dark"] table thead td,
  [data-bs-theme="dark"] table thead th,
  [data-bs-theme="dark"] table thead td,
  body.dark table thead th,
  body.dark table thead td,
  body.dark-mode table thead th,
  body.dark-mode table thead td,
  body.dark-only table thead th,
  body.dark-only table thead td,
  body.dark-sidebar table thead th,
  body.dark-sidebar table thead td,
  html.dark table thead th,
  html.dark table thead td {
    color: var(--bs-emphasis-color, #f8f9fa) !important;
  }
  table thead th,
  table thead td,
  .table thead th,
  .table thead td {
    text-align: center !important;
  }
  :root[data-bs-theme="dark"] .table-light,
  body[data-bs-theme="dark"] .table-light,
  [data-bs-theme="dark"] .table-light,
  body.dark .table-light,
  body.dark-mode .table-light,
  body.dark-only .table-light,
  body.dark-sidebar .table-light,
  html.dark .table-light {
    --bs-table-color: var(--bs-emphasis-color, #f8f9fa);
    color: var(--bs-emphasis-color, #f8f9fa) !important;
  }
  :root[data-bs-theme="dark"] thead.table-light,
  body[data-bs-theme="dark"] thead.table-light,
  [data-bs-theme="dark"] thead.table-light,
  body.dark thead.table-light,
  body.dark-mode thead.table-light,
  body.dark-only thead.table-light,
  body.dark-sidebar thead.table-light,
  html.dark thead.table-light {
    --bs-table-color: var(--bs-emphasis-color, #f8f9fa);
    color: var(--bs-emphasis-color, #f8f9fa) !important;
  }
  :root[data-bs-theme="dark"] .table-light th,
  :root[data-bs-theme="dark"] .table-light td,
  :root[data-bs-theme="dark"] thead.table-light th,
  :root[data-bs-theme="dark"] thead.table-light td,
  body[data-bs-theme="dark"] .table-light th,
  body[data-bs-theme="dark"] .table-light td,
  body[data-bs-theme="dark"] thead.table-light th,
  body[data-bs-theme="dark"] thead.table-light td,
  [data-bs-theme="dark"] .table-light th,
  [data-bs-theme="dark"] .table-light td,
  [data-bs-theme="dark"] thead.table-light th,
  [data-bs-theme="dark"] thead.table-light td,
  body.dark .table-light th,
  body.dark .table-light td,
  body.dark thead.table-light th,
  body.dark thead.table-light td,
  body.dark-mode .table-light th,
  body.dark-mode .table-light td,
  body.dark-mode thead.table-light th,
  body.dark-mode thead.table-light td,
  body.dark-only .table-light th,
  body.dark-only .table-light td,
  body.dark-only thead.table-light th,
  body.dark-only thead.table-light td,
  body.dark-sidebar .table-light th,
  body.dark-sidebar .table-light td,
  body.dark-sidebar thead.table-light th,
  body.dark-sidebar thead.table-light td,
  html.dark .table-light th,
  html.dark .table-light td,
  html.dark thead.table-light th,
  html.dark thead.table-light td {
    color: inherit !important;
  }
</style>
