<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Parcial: views/layout/_partials/sidebar.php
 *
 * Versión estática para probar compatibilidad con sidebar-menu.js.
 * (Sin fetch, igual que el template original).
 */
?>
<header class="main-nav">
  <nav>
    <div class="main-navbar">
      <div class="left-arrow" id="left-arrow"><i data-feather="arrow-left"></i></div>
      <div id="mainnav">
        <ul class="nav-menu custom-scrollbar">
          <!-- General -->
          <li class="sidebar-main-title">
            <div>
              <h6>General</h6>
            </div>
          </li>
          <li class="dropdown">
            <a class="nav-link menu-title" href="javascript:void(0)">
              <i data-feather="home"></i><span>Dashboard</span>
              <div class="according-menu"><i class="fa fa-angle-right"></i></div>
            </a>
            <ul class="nav-submenu menu-content" style="display: none;">
              <li><a href="<?= url('/home') ?>">Inicio</a></li>
            </ul>
          </li>

          <li class="dropdown">
            <a class="nav-link menu-title" href="javascript:void(0)">
              <i data-feather="package"></i><span>Ingresos</span>
              <div class="according-menu"><i class="fa fa-angle-right"></i></div>
            </a>
            <ul class="nav-submenu menu-content" style="display: none;">
              <li><a href="<?= url('/ingresos') ?>">Ingresos</a></li>
            </ul>
          </li>

          <!-- Parámetros -->
          <li class="sidebar-main-title">
            <div>
              <h6>Parámetros</h6>
            </div>
          </li>
          <li class="dropdown">
            <a class="nav-link menu-title" href="javascript:void(0)">
              <i data-feather="settings"></i><span>Parámetros</span>
              <div class="according-menu"><i class="fa fa-angle-right"></i></div>
            </a>
            <ul class="nav-submenu menu-content" style="display: none;">
              <?php
              $listados = [
                'Choferes' => 'choferes', 
                'Clientes' => 'clientes', 
                'Clases' => 'clases',
                'Grupos' => 'grupos',
                'Productos' => 'productos'
              ];
              foreach ($listados as $titulo => $listado) {
                echo "<li><a href='" . url('/parametros/' . $listado) . "'>" . $titulo . "</a></li>";
              }
              ?>
            </ul>
          </li>
        </ul>
      </div>
      <div class="right-arrow" id="right-arrow"><i data-feather="arrow-right"></i></div>
    </div>
  </nav>
</header>