<?php

declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Parcial: views/layout/_partials/topbar.php
 *
 * Propósito:
 *   - Encabezado superior (navbar principal).
 *   - Muestra logo claro/oscuro, título de proyecto y botón logout.
 *   - Basado en Viho template, simplificado.
 *
 * Variables usadas:
 *   - $appName   (string) título del proyecto (desde .env PROYECTO_TITULO)
 *   - $logoLight (string) URL logo modo claro
 *   - $logoDark  (string) URL logo modo oscuro
 *
 * Requiere helpers url(), env() ya definidos en el proyecto.
 */

$e = static fn($s) => htmlspecialchars((string) $s, ENT_QUOTES, 'UTF-8');

$breadcrumbItems = null;
if (function_exists('sol_get_section')) {
  $breadcrumbItems = sol_get_section('breadcrumb', null);
}

if (!is_array($breadcrumbItems) || $breadcrumbItems === []) {
  $breadcrumbItems = [
    ['label' => 'Dashboard', 'url' => '/control/dashboard'],
    ['label' => $pageTitle, 'url' => null],
  ];
}
?>
<div class="page-main-header">
  <div class="main-header-right row m-0 align-items-center">
    <div class="main-header-left d-flex align-items-center col-auto">
      <div class="header-logo-wrapper col-auto">
        <h3 class="text-white"><?= $e($appName) ?></h3>
      </div>
      <div class="toggle-sidebar ms-3">
        <i class="status_toggle middle" data-feather="align-center" id="sidebar-toggle"></i>
      </div>
    </div>
    <div class="left-menu-header col">
      <div class="row align-items-center">
        <div class="col-sm-6">
          
        </div>
      </div>

    </div>
    <div class="nav-right col-auto p-0">
      <ul class="nav-menus d-flex align-items-center gap-3 m-0">
        <li>
          <a class="text-dark" href="#" onclick="if(window.toggleFullScreen)toggleFullScreen();return false;">
            <i class="fa-solid fa-expand"></i>
          </a>
        </li>
        <li>
          <a class="text-dark mode" href="#"></a>
        </li>
        <li class="p-0">
          <a class="btn btn-sm btn-primary-light" href="<?= $e(url('/logout')) ?>">
            <i data-feather="log-out"></i> Salir
          </a>
        </li>
        <li class="d-lg-none mobile-toggle w-auto"><i data-feather="more-horizontal"></i></li>
      </ul>
    </div>
  </div>
</div>