<?php
// views/Common/_partials/warehouse/_rack_layout.column_cards.php
declare(strict_types=1);

/**
 * Modo: column_cards
 * Clases según SCSS: .column-card*, .level-row*, .pallet-cell.pallet-cell--slot
 * Variables: $layout, $posMap, $positions, $depCode, $rackCode, $cols, $niv
 */
if (!function_exists('h')) {
    function h($s)
    {
        return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
    }
}

$posInfo = [];
foreach ($positions as $p) {
    $fid = $p['fondo_id'] ?? null;
    if ($fid !== null) {
        $posInfo[(int)$fid] = [
            'code_full'    => (string)($p['code_full'] ?? ''),
            'status'       => (string)($p['status'] ?? 'ACTIVE'),
            'is_pick_face' => (int)($p['is_pick_face'] ?? 0),
        ];
    }
}
?>
<div class="row g-2">
    <?php foreach ($cols as $colName): ?>
        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
            <div class="column-card">
                <div class="column-card__header">
                    <div class="column-card__title"><?= h($colName) ?></div>
                    <div class="column-card__sub"><?= h($rackCode) ?> • <?= h($depCode) ?></div>
                </div>
                <div class="column-card__body">
                    <?php foreach ($niv as $nivel): ?>
                        <?php $fondos = $layout[$depCode][$rackCode][$colName][$nivel] ?? []; ?>
                        <div class="level-row">
                            <div class="level-row__label"><?= h($nivel) ?></div>
                            <div class="level-row__slots">
                                <?php if (empty($fondos)): ?>
                                    <span class="text-muted small">—</span>
                                <?php else: ?>
                                    <?php foreach ($fondos as $f): ?>
                                        <?php
                                        $posId  = (int)($posMap[$depCode][$rackCode][$colName][$nivel][$f] ?? 0);
                                        $info   = $posInfo[$posId] ?? null;
                                        $status = $info['status'] ?? 'ACTIVE';
                                        $pick   = (int)($info['is_pick_face'] ?? 0);
                                        $code   = $info['code_full'] ?? ($depCode . '-' . $rackCode . '-' . $colName . '-' . $nivel . '-F' . str_pad((string)$f, 2, '0', STR_PAD_LEFT));

                                        $cls = 'pallet-cell pallet-cell--slot js-pos';
                                        if ($pick) {
                                            $cls .= ' pallet-cell--picking';
                                        } // <- mantener
                                        $cls .= match ($status) {
                                            'BLOCKED' => ' is-blocked',
                                            'INACTIVE' => ' is-inactive',
                                            default => ' is-active'
                                        };


                                        $top  = $colName . ' • ' . $nivel;
                                        $main = 'F' . str_pad((string)$f, 2, '0', STR_PAD_LEFT);
                                        ?>
                                        <div id="cell-<?= $posId ?>" class="<?= h($cls) ?>"
                                            data-pos-id="<?= $posId ?>"
                                            data-code="<?= h($code) ?>"
                                            data-status="<?= h($status) ?>"
                                            data-pick="<?= $pick ?>"
                                            data-col="<?= h($colName) ?>"
                                            data-niv="<?= h($nivel) ?>"
                                            data-fon="<?= (int)$f ?>">
                                            <div class="cell-top"><?= h($top) ?></div>
                                            <div class="cell-main" title="<?= h($code) ?>"><?= h($main) ?></div>
                                            <?php if ($pick): ?>
                                                <span class="cell-badge" title="Pick face">⭐</span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>