<?php
// views/Common/_partials/warehouse/_rack_layout.cubes.php
declare(strict_types=1);

/**
 * Modo: cubes (3D)
 * - Muestra SOLO el valor del fondo (Fxx) centrado en la cara frontal.
 * - Sin etiquetas adicionales ni badges que desplacen la cara.
 * Variables: $layout, $posMap, $positions, $depCode, $rackCode, $cols, $niv
 */
if (!function_exists('h')) {
    function h($s)
    {
        return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
    }
}

$posInfo = [];
foreach ($positions as $p) {
    $fid = $p['fondo_id'] ?? null;
    if ($fid !== null) {
        $posInfo[(int)$fid] = [
            'code_full'    => (string)($p['code_full'] ?? ''),
            'status'       => (string)($p['status'] ?? 'ACTIVE'),
            'is_pick_face' => (int)($p['is_pick_face'] ?? 0),
        ];
    }
}
?>
<div class="container-fluid">
    <div class="row g-3">
        <?php foreach ($cols as $colName): ?>
            <div class="col-6 col-md-3 col-lg-2 text-center">
                <div class="fw-semibold small text-secondary mb-2"><?= h($colName) ?></div>

                <?php foreach ($niv as $nivel): ?>
                    <?php $fondos = $layout[$depCode][$rackCode][$colName][$nivel] ?? []; ?>
                    <div class="mb-2">
                        <span class="badge text-bg-secondary"><?= h($nivel) ?></span>
                        <div class="d-flex justify-content-center flex-wrap gap-2 mt-2">
                            <?php foreach ($fondos as $f): ?>
                                <?php
                                $posId  = (int)($posMap[$depCode][$rackCode][$colName][$nivel][$f] ?? 0);
                                $info   = $posInfo[$posId] ?? null;
                                $status = $info['status'] ?? 'ACTIVE';
                                $pick   = (int)($info['is_pick_face'] ?? 0); // no mostramos estrella aquí
                                $code   = $info['code_full'] ?? ($depCode . '-' . $rackCode . '-' . $colName . '-' . $nivel . '-F' . str_pad((string)$f, 2, '0', STR_PAD_LEFT));
                                $cls    = 'fondo-cubo js-pos';
                                // Si querés marcar picking con patrón global, podés dejar la clase:
                                $cls = 'fondo-cubo js-pos';
                                if ($pick) {
                                    $cls .= ' is-picking';
                                } // <- para el anillo amarillo
                                $cls .= match ($status) {
                                    'BLOCKED' => ' is-blocked',
                                    'INACTIVE' => ' is-inactive',
                                    default => ' is-active'
                                };


                                $label  = str_pad((string)$f, 2, '0', STR_PAD_LEFT);
                                ?>
                                <div id="cell-<?= $posId ?>" class="<?= h($cls) ?>"
                                    data-pos-id="<?= $posId ?>"
                                    data-code="<?= h($code) ?>"
                                    data-status="<?= h($status) ?>"
                                    data-pick="<?= $pick ?>"
                                    data-col="<?= h($colName) ?>"
                                    data-niv="<?= h($nivel) ?>"
                                    data-fon="<?= (int)$f ?>"
                                    title="<?= h($code) ?>">
                                    <div class="cubo-inner">
                                        <!-- Cara frontal: solo Fxx centrado (sin badges para no alterar layout) -->
                                        <div class="cara front" style="position:relative;">
                                            <div style="
                        position:absolute; inset:0;
                        display:flex; align-items:center; justify-content:center;
                        font-weight:700; font-size:.75rem; letter-spacing:.2px;
                        pointer-events:none;
                      "><?= h($label) ?></div>
                                        </div>
                                        <!-- Otras caras estructurales -->
                                        <div class="cara back"></div>
                                        <div class="cara right"></div>
                                        <div class="cara left"></div>
                                        <div class="cara top"></div>
                                        <div class="cara bottom"></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endforeach; ?>
    </div>
</div>