<?php
declare(strict_types=1);
if (!function_exists('h')) {
  function h($s): string
  {
    return htmlspecialchars((string) $s, ENT_QUOTES, 'UTF-8');
  }
}
if (!function_exists('hex_color_contrast')) {
  function hex_color_contrast(?string $hex): string
  {
    if (!$hex)
      return '#212529'; // gris oscuro por defecto
    $hex = ltrim($hex, '#');
    if (strlen($hex) !== 6)
      return '#212529';
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    // luminancia percibida: YIQ
    $yiq = (($r * 299) + ($g * 587) + ($b * 114)) / 1000;
    return ($yiq >= 150) ? '#212529' : '#ffffff';
  }
}
?>
<div class="rack-microtiles table-responsive">
  <table class="table table-bordered table-sm align-middle text-center mb-0">
    <thead class="table-light">
      <tr>
        <th class="text-muted small">Nivel ↓<br />Columna →</th>
        <?php foreach ($cols as $col): ?>
          <th><?= h($col) ?></th>
        <?php endforeach; ?>
      </tr>
    </thead>
    <tbody>
      <?php
      $nivDesc = $niv;
      usort($nivDesc, 'strnatcmp');
      $nivDesc = array_reverse($nivDesc);
      foreach ($nivDesc as $nivCode):
        ?>
        <tr>
          <th class="text-muted"><?= h($nivCode) ?></th>
          <?php foreach ($cols as $colCode): ?>
            <td class="p-0">
              <div class="microtile d-flex flex-wrap justify-content-center">
                <?php
                $fondos = $layout[$depCode][$rackCode][$colCode][$nivCode] ?? [];
                sort($fondos, SORT_NUMERIC);
                foreach ($fondos as $fIndex):
                  $fid = $posMap[$depCode][$rackCode][$colCode][$nivCode][$fIndex] ?? null;
                  $p = null;
                  if ($fid) {
                    foreach ($positions as $pp) {
                      if (($pp['fondo_id'] ?? $pp['id'] ?? null) == $fid) {
                        $p = $pp;
                        break;
                      }
                    }
                  }
                  $status = $p['status'] ?? 'INACTIVE';
                  $cls = match ($status) {
                    'ACTIVE' => 'pos-active',
                    'BLOCKED' => 'pos-blocked',
                    default => 'pos-inactive'
                  };
                  $palletsCnt = (int) ($p['pallets'] ?? 0);
                  $occCls = $palletsCnt > 0 ? 'is-occupied' : 'is-empty';
                  $bg = $p['color_hex'] ?? null;
                  if (!$bg) {
                    // fallback por ocupación: ocupado → verde claro; vacío → gris claro
                    $bg = $palletsCnt > 0 ? '#e9f7ef' : '#f8f9fa';
                  }
                  $fg = hex_color_contrast($bg);
                  $titleTip = ($p['code_full'] ?? ($colCode . '-' . $nivCode . '-F' . $fIndex));
                  $palletsCnt = (int) ($p['pallets'] ?? 0);
                  $labelLine2 = $palletsCnt > 0
                    ? (string) ($p['producto_id'] ?? '')  // o $p['producto_nombre'] si prefieres
                    : '';
                  ?>
                  <div class="microtile-cell <?= h($cls) ?> <?= h($occCls) ?> clickable" title="<?= h($titleTip) ?>"
                    data-pos-id="<?= h((string) ($p['id'] ?? $fid ?? '')) ?>"
                    data-code-full="<?= h($p['code_full'] ?? ($colCode . '-' . $nivCode . '-F' . $fIndex)) ?>"
                    data-dep-code="<?= h($depCode) ?>"
                    data-rack-code="<?= h($rackCode) ?>"
                    data-col-code="<?= h($colCode) ?>"
                    data-niv-code="<?= h($nivCode) ?>"
                    data-depth-index="<?= h((string) $fIndex) ?>"
                    style="<?= $bg ? 'background-color:' . h($bg) . ';color:' . h($fg) . ';' : '' ?>;min-width:2.2rem;min-height:2.2rem;display:flex;align-items:center;justify-content:center;flex-direction:column;border-radius:.35rem;margin:.15rem;border:1px solid rgba(0,0,0,.1);"
                    >
                    <div style="line-height:1; font-size:.85rem;"><?= h($fIndex) ?></div>
                    <?php if ($labelLine2 !== ''): ?>
                      <div style="line-height:1; font-size:.65rem; opacity:.9;"><?= h($labelLine2) ?></div>
                    <?php endif; ?>
                  </div>
                <?php endforeach; ?>
              </div>
            </td>
          <?php endforeach; ?>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>