<?php
// views/Common/_partials/warehouse/_rack_layout.shelf_strips.php
declare(strict_types=1);

/**
 * Modo: shelf_strips
 * Clases según SCSS: .shelf-strips*, .shelf-pill*
 * Variables disponibles desde el dispatcher:
 * - $layout, $posMap, $positions, $depCode, $rackCode, $cols, $niv
 */
if (!function_exists('h')) { function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } }

$posInfo = [];
foreach ($positions as $p) {
    $fid = $p['fondo_id'] ?? null;
    if ($fid !== null) {
        $posInfo[(int)$fid] = [
            'code_full'    => (string)($p['code_full'] ?? ''),
            'status'       => (string)($p['status'] ?? 'ACTIVE'),
            'is_pick_face' => (int)($p['is_pick_face'] ?? 0),
        ];
    }
}
$colsCount = max(0, count($cols));
?>
<div class="shelf-strips" style="--cols: <?= (int)$colsCount ?>;">
  <div class="shelf-strips__header">
    <div class="shelf-strips__header-spacer"></div>
    <?php foreach ($cols as $colName): ?>
      <div class="shelf-strips__colname"><?= h($colName) ?></div>
    <?php endforeach; ?>
  </div>

  <?php foreach ($niv as $nivel): ?>
    <div class="shelf-strips__row" data-nivel="<?= h($nivel) ?>">
      <div class="shelf-strips__level">
        <span class="shelf-strips__level-badge"><?= h($nivel) ?></span>
      </div>

      <?php foreach ($cols as $colName): ?>
        <?php $fondos = $layout[$depCode][$rackCode][$colName][$nivel] ?? []; ?>
        <div class="shelf-strips__group">
          <?php if (empty($fondos)): ?>
            <span class="text-muted small">—</span>
          <?php else: ?>
            <?php foreach ($fondos as $f): ?>
              <?php
                $posId  = (int)($posMap[$depCode][$rackCode][$colName][$nivel][$f] ?? 0);
                $info   = $posInfo[$posId] ?? null;
                $status = $info['status'] ?? 'ACTIVE';
                $pick   = (int)($info['is_pick_face'] ?? 0);
                $code   = $info['code_full'] ?? ($depCode.'-'.$rackCode.'-'.$colName.'-'.$nivel.'-F'.str_pad((string)$f,2,'0',STR_PAD_LEFT));

                $cls = 'shelf-pill js-pos ';
                $cls .= match ($status) {
                    'BLOCKED'  => 'shelf-pill--blocked',
                    'INACTIVE' => 'shelf-pill--inactive',
                    default    => 'shelf-pill--active',
                };
                
                if ($pick) { $cls .= ' shelf-pill--picking'; }

                $label = 'F' . str_pad((string)$f, 2, '0', STR_PAD_LEFT);
              ?>
              <div id="cell-<?= $posId ?>" class="<?= h($cls) ?>"
                   data-pos-id="<?= $posId ?>"
                   data-code="<?= h($code) ?>"
                   data-status="<?= h($status) ?>"
                   data-pick="<?= $pick ?>"
                   data-col="<?= h($colName) ?>"
                   data-niv="<?= h($nivel) ?>"
                   data-fon="<?= (int)$f ?>">
                <span class="shelf-pill__label"><?= h($label) ?></span>
              </div>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endforeach; ?>
</div>
