<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/parametros/choferes/index.php
 * P1: tabla vacía con DataTables + scripts específicos.
 */

// Raíz del proyecto desde esta vista: views/parametros/choferes/index.php
$BASE = dirname(__DIR__, 3); // choferes -> parametros -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Móviles disponibles por día');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/operaciones/moviles_disponibles_list.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'movilesDisponiblesTable';
$tableDescription = 'Listado de móviles disponibles';

// -------------------------
// Contenido principal
// -------------------------
// Contenido con filtro de fecha arriba de la tabla
$hoy = date('Y-m-d');
ob_start();
?>

<div class="row mb-3">
	<div class="col-md-4">
		<label for="filtroFecha" class="form-label">Fecha</label>
		<div class="input-group">
			<input type="date" id="filtroFecha" class="form-control" value="<?= htmlspecialchars($hoy, ENT_QUOTES, 'UTF-8') ?>" />
			<button type="button" id="btnAplicarFiltro" class="btn btn-primary">
				<i class="fa fa-search me-1"></i> Aplicar
			</button>
		</div>
	</div>
	<div class="col-md-8 d-flex align-items-end justify-content-end gap-2 flex-wrap">
		<button type="button" id="btnVerTodos" class="btn btn-outline-secondary">
			<i class="fa fa-list me-1"></i> Ver todos los móviles
		</button>
		<button type="button" id="btnSeedMoviles" class="btn btn-outline-success">
			<i class="fa fa-refresh me-1"></i> Cargar catálogo del día
		</button>
		<!-- Botón PDF (se enlaza por JS con la fecha seleccionada) -->
		<button type="button" id="btnPdfMoviles" class="btn btn-outline-primary">
			<i class="fa fa-file-pdf-o me-1"></i> Imprimir PDF
		</button>
	</div>
	<div class="col-12"><hr/></div>
</div>

<?php
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
