<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/parametros/clases/index.php
 * P1: tabla vacía con DataTables + scripts específicos.
 */

// Raíz del proyecto desde esta vista: views/parametros/clases/index.php
$BASE = dirname(__DIR__, 3); // clases -> parametros -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Clases de productos');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/parametros/clases_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'clasesTable';
$tableDescription = 'Listado de clases de productos';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
