<?php
declare(strict_types=1);

/**
 * SOL - Sistema de Operaciones Logísticas
 * Vista: views/parametros/clientes/index.php
 * P1: tabla vacía con DataTables + scripts específicos.
 */

// Raíz del proyecto desde esta vista: views/parametros/clientes/index.php
$BASE = dirname(__DIR__, 3); // clientes -> parametros -> views -> raíz

require_once $BASE . '/app/Support/ViewHelpers.php';
require_once $BASE . '/app/Support/Assets.php';

// -------------------------
// Meta
// -------------------------
sol_section('page_title', 'Clientes');

// -------------------------
// DataTables + script de la página
// -------------------------
sol_dt_assets('/page-scripts/pages/parametros/clientes_scripts.js');

// -------------------------
// Variables para el partial de tabla
// -------------------------
$tableId          = 'clientesTable';
$tableDescription = 'Listado de clientes';

// -------------------------
// Contenido principal
// -------------------------
ob_start();
include project_path('views/layout/_partials/table-def.php');
$content = ob_get_clean();

// -------------------------
// Render del layout
// -------------------------
include project_path('views/layout/layout_app.php');
